import os
import hydra
from omegaconf import OmegaConf


def register_resolvers() -> None:
    OmegaConf.register_new_resolver('env', os.getenv)
    OmegaConf.register_new_resolver('replace', str.replace)


def get_output_dir() -> str:
    return hydra.core.hydra_config.HydraConfig.get().runtime.output_dir
