# GCN-based Recommender Systems
This is our Tensorflow implementation for the paper:

>Graph Convolution Network based Recommender Systems: Learning Guarantee and Item Mixture Powered Strategy.

## Environment Requirement
The code has been tested running under Python 3.6.5. The required packages are as follows:
* tensorflow == 1.11.0
* numpy == 1.14.3
* scipy == 1.1.0
* sklearn == 0.19.1
* cython == 0.29.15
## C++ evaluator
We have implemented C++ code to output metrics during and after training, which is much more efficient than python evaluator. It needs to be compiled first using the following command. 
```
python setup.py build_ext --inplace
```
After compilation, the C++ code will run by default instead of Python code.

## Examples to run a 3-layer Model
The instruction of commands has been clearly stated in the codes (see the parser function in LightGCN/utility/parser.py).
### Gowalla dataset
* run our boosting strategy
```
python IMIX.py --dataset gowalla --regs [1e-4] --embed_size 64 --layer_size [64,64,64] --lr 0.002 --batch_size 1024 --epoch 200 --alg_type ngcf
```
* run original model
```
python LightGCN.py --dataset gowalla --regs [1e-4] --embed_size 64 --layer_size [64,64,64] --lr 0.002 --batch_size 1024 --epoch 200 --alg_type ngcf
```

### Yelp2018 dataset
* run our boosting strategy
```
python IMIX.py --dataset yelp2018 --regs [1e-4] --embed_size 64 --layer_size [64,64,64] --lr 0.002 --batch_size 1024 --epoch 200 --alg_type ngcf
```
* run original model
```
python LightGCN.py --dataset yelp2018 --regs [1e-4] --embed_size 64 --layer_size [64,64,64] --lr 0.002 --batch_size 1024 --epoch 200 --alg_type ngcf
```
NOTE : the duration of training and testing depends on the running environment.
## Dataset
We provide two processed datasets: Gowalla, Yelp2018.
* `train.txt`
  * Train file.
  * Each line is a user with her/his positive interactions with items: userID\t a list of itemID\n.

* `test.txt`
  * Test file (positive instances).
  * Each line is a user with her/his positive interactions with items: userID\t a list of itemID\n.
  * Note that here we treat all unobserved interactions as the negative instances when reporting performance.
  
* `user_list.txt`
  * User file.
  * Each line is a triplet (org_id, remap_id) for one user, where org_id and remap_id represent the ID of the user in the original and our datasets, respectively.
  
* `item_list.txt`
  * Item file.
  * Each line is a triplet (org_id, remap_id) for one item, where org_id and remap_id represent the ID of the item in the original and our datasets, respectively.

## Efficiency Improvements:
  * Parallelized sampling on CPU
  * C++ evaluation for top-k recommendation

=======
