# Neural Superposition Networks: Supporting Code

This code reproduces the experimental results for the paper superposition networks, which develops novel
neural network architectures to represent the solution functions of linear differential equations.

## Usage

Assuming `Python 3.10` is in your `$PATH` as `python`, a consistent environment to the one used to run experiments can
be set up via `requirements.txt` and `pip`.

To run an experiment, execute:

```python run_experiment.py -e $EXPERIMENT_NAME -m $METHOD_NAME -s $SEED```

where `$EXPERIMENT_NAME` is one of the subdirectories of `src`, namely `[heat1, heat2, laplace1, laplace2, navierstokes,
burgers]`, `$METHOD` is derived directly from the files within subdirectories, namely one of `[superposition,
holomorphic, ncl, pinn, pinni, pinnb, rar, adaptiveactivation, raradaptiveactivation]` and `$SEED` is an integer
denoting the random seed of the experiment.

Within the paper, we report results from letting `$SEED` run between 1 and 10 (inclusive).

Each invocation of the command above yields an appropriately serialised set of network weights within `weights/`.

Benchmark solutions from finite element simulations are found in `benchmarks/` within appropriately named
subdirectories.

Root-mean squared errors reported in the main can be calculated by running `python analyse_results.py` after all
networks have been trained.
