import argparse
import importlib
from src import utils


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("-e", "--experiment", type=str)
    parser.add_argument("-m", "--method", type=str)
    parser.add_argument("-s", "--seed", type=int)
    args = parser.parse_args()
    utils.set_rng_seed(args.seed)
    model_id = f"{args.experiment}_{args.method}_{args.seed}"
    mod_name = ".".join(["src", args.experiment, args.method])
    mod_name = f"src.{args.experiment}.{args.method}"
    mod = importlib.import_module(mod_name)
    print(f"Starting {args.experiment}, {args.method}, {args.seed}")
    utils.train(mod, model_id)
