##################################### functions (some are taken from R package changepoints)
library(extraDistr)

unif_vector = function(x,pi_a){
  d = length(x)
  T = rbinom(1,1,pi_a)
  if(T == 1){
    z_temp = rsign(d)
    while(sum(z_temp*x) < 0){
      z_temp = rsign(d)
    }
    z = z_temp
  }
  if(T == 0){
    z_temp = rsign(d)
    while(sum(z_temp*x) > 0){
      z_temp = rsign(d)
    }
    z = z_temp
  }
  return(z)
}
sampling = function(x, pri_level){
  e = exp(1)
  d = length(x)
  pi_a = exp(pri_level)/(exp(pri_level)+1)
  if (d%%2 == 1){
    C_d_inver = 1/(2^{d-1})*choose(d-1, (d-1)/2)
  }else{
    C_d_inver = 1/(2^{d-1}+1/2*choose(d,d/2))*choose(d-1, d/2)
  }
  temp = rbinom(sum(x==0),1,0.5)
  temp1 = ifelse(temp == 0, -1, 1)
  x[which(x==0)] = temp1
  z = unif_vector(x,pi_a)
  B = 1/C_d_inver*(e^pri_level+1)/(e^pri_level-1)
  B = ifelse(is.nan(B),3*sqrt(d)/pri_level,B)
  return(z*B)
}

sbc = function(data_m, q){
  total_dim = dim(data_m)[1]*dim(data_m)[2]
  rr = matrix(rbinom(total_dim,1,q),nrow = dim(data_m)[1])
  rr.add = rr+data_m
  rr.add[rr.add>1] = 0
  return(rr.add)
}

CUSUM.vec = function(data_mat, s, e, t){
  n_st = t - s + 1
  n_se = e - s + 1
  n_te = e - t
  p = dim(data_mat)[1]
  if(t-s<3 | e-t<2){
    result_vec = rep(0, p)
  }else{
    result_vec = sqrt(n_te/(n_se*n_st)) * rowSums(data_mat[,s:t]) - sqrt(n_st/(n_se*n_te)) * rowSums(data_mat[,(t+1):e])
  }
  return(result_vec)
}


CUSUM.innerprod = function(data_mat1, data_mat2, s, e, t){
  return(sum(CUSUM.vec(data_mat1, s, e, t) * CUSUM.vec(data_mat2, s, e, t)))
}

alpha = 1
gen_pri_node = function(conn_matrix, seglength){
  pri_data = NULL
  for(i in 1:seglength){
    raw_data1 = apply(conn_matrix, c(1,2),function (x) rbinom(1,1,x))
    pri_data1 = as.vector(apply(raw_data1, 1, sampling, pri_level = alpha))
    pri_data = cbind(pri_data,pri_data1)
  }
  return(pri_data)
}

BS.network = function (data_mat1, data_mat2, s, e, delta = 2, level = 0) 
{
  S = NULL
  Dval = NULL
  Level = NULL
  Parent = NULL
  if (e - s <= 2 * delta) {
    return(list(S = S, Dval = Dval, Level = Level, Parent = Parent))
  }
  else {
    level = level + 1
    parent = matrix(c(s, e), nrow = 2)
    a = rep(0, e - s - 2 * delta + 1)
    for (t in (s + delta):(e - delta)) {
      a[t - s - delta + 1] = CUSUM.innerprod(data_mat1,data_mat2,s,e,t)
    }
    best_value = max(a)
    best_t = which.max(a) + s + delta - 1
    temp1 = BS.network(data_mat1, data_mat2, s, best_t - 1, delta, level)
    temp2 = BS.network(data_mat1, data_mat2, best_t, e, delta, level)
    S = c(temp1$S, best_t, temp2$S)
    Dval = c(temp1$Dval, best_value, temp2$Dval)
    Level = c(temp1$Level, level, temp2$Level)
    Parent = cbind(temp1$Parent, parent, temp2$Parent)
    result = list(S = S, Dval = Dval, Level = Level, Parent = Parent)
    class(result) = "BS"
    return(result)
  }
}

Hausdorff.dist = function(vec1, vec2){
  vec = c(vec1, vec2)
  if(!all(c(vec == floor(vec)), vec >= 0)){
    stop("vec1 and vec2 should be subsets of {0, 1, ...}")
  }
  dist = matrix(0, nrow = length(vec1), ncol = length(vec2))
  for (i in 1:nrow(dist)){
    for (j in 1:ncol(dist)){
      dist[i,j] = abs(vec1[i] - vec2[j])
    }
  }
  dH = max(max(apply(dist, 2, function(x) min(x))), max(apply(dist, 1, function(x) min(x))))
  return(dH)
}


thresholdBS <- function(BS_object, tau){
  UseMethod("thresholdBS", BS_object)
}



thresholdBS.BS = function(BS_object, tau){
  if(tau <= 0){
    stop("The threshold tau should be a positive value.")
  }
  level_unique = unique(BS_object$Level[order(BS_object$Level)])
  level_length = length(level_unique)
  BS_tree = vector("list", level_length)
  BS_tree[[1]] = data.frame(current = 1, parent = NA, location = BS_object$S[order(BS_object$Level)][1], value = BS_object$Dval[order(BS_object$Level)][1])
  for(i in 2:level_length){
    idx_curr = cumsum(table(BS_object$Level))[i-1] + 1:table(BS_object$Level)[i]
    idx_prev = cumsum(table(BS_object$Level))[i-1] + 1 - table(BS_object$Level)[i-1]:1
    interval_prev = as.matrix(BS_object$Parent[,order(BS_object$Level)][,idx_prev])
    e_curr = BS_object$Parent[,order(BS_object$Level)][2,idx_curr]
    BS_tree[[i]] = data.frame(current = 1:length(idx_curr),
                              parent = sapply(e_curr, function(x) which(rbind(interval_prev[1,] <= x & interval_prev[2,] >= x))), 
                              location = BS_object$S[order(BS_object$Level)][idx_curr],
                              value = BS_object$Dval[order(BS_object$Level)][idx_curr])
  }
  BS_tree_new = BS_tree
  BS_tree_new[[1]] = BS_tree[[1]][,3:4]
  BS_tree_new[[1]]$location = paste0("N",BS_tree_new[[1]]$location)
  for(j in 2:level_length){
    BS_tree_new[[j]]$parent = sapply(BS_tree_new[[j]]$parent, function(x){BS_tree_new[[j-1]]$location[x]})
    BS_tree_new[[j]]$location = paste0(BS_tree_new[[j]]$parent, "$N", BS_tree_new[[j]]$location)
    BS_tree_new[[j]] = BS_tree_new[[j]][,3:4]
  }
  binary_tree = list()
  binary_tree$name = "Binary Segmentation Tree"
  for(j in 1:level_length){
    for(k in 1:nrow(BS_tree_new[[j]])){
      eval(parse(text=paste0("binary_tree$",BS_tree_new[[j]]$location[k],"$value","<-",BS_tree_new[[j]]$value[k])))
    }
  }
  BS_tree_node = data.tree::as.Node(binary_tree)
  
  BS_tree_trimmed = BS_tree
  for(i in 1:level_length){
    idx_remove = BS_tree_trimmed[[i]]$current[BS_tree_trimmed[[i]]$value <= tau]
    BS_tree_trimmed[[i]] = BS_tree_trimmed[[i]][BS_tree_trimmed[[i]]$value > tau,]
    if(length(idx_remove) > 0){
      idx_remove_parent = idx_remove
      k = i+1
      while(length(idx_remove_parent) > 0 & k <= level_length){
        temp = one.step.trim(idx_remove_parent, BS_tree_trimmed[[k]])
        BS_tree_trimmed[[k]] = temp$data_children_trimmed
        idx_remove_parent = temp$idx_remove_children
        k = k + 1
      }
    }
  }
  points_at_level = sapply(BS_tree_trimmed, dim)[1,]
  level = unlist(sapply(1:length(points_at_level), function(x) rep(x, points_at_level[x])))
  change_points = do.call(rbind, BS_tree_trimmed)[,c(3,4)]
  change_points$level = level
  rownames(change_points) = c()
  BS_tree_trimmed = BS_tree_trimmed[points_at_level != 0]
  if(length(BS_tree_trimmed) == 0){
    return(list(BS_tree = BS_tree_node, BS_tree_trimmed = NULL, cpt_hat = NULL))
  }
  BS_tree_trimmed_new = BS_tree_trimmed
  BS_tree_trimmed_new[[1]] = BS_tree_trimmed[[1]][,3:4]
  BS_tree_trimmed_new[[1]]$location = paste0("N",BS_tree_trimmed_new[[1]]$location)
  if(length(BS_tree_trimmed) == 1){
    return(list(BS_tree_trimmed = BS_tree_trimmed[[1]], cpt_hat = change_points))
  }
  for(j in 2:sum(points_at_level != 0)){
    BS_tree_trimmed_new[[j]]$parent = sapply(BS_tree_trimmed_new[[j]]$parent, function(x){BS_tree_trimmed_new[[j-1]]$location[rownames(BS_tree_trimmed_new[[j-1]]) == x]})
    BS_tree_trimmed_new[[j]]$location = paste0(BS_tree_trimmed_new[[j]]$parent, "$N", BS_tree_trimmed_new[[j]]$location)
    BS_tree_trimmed_new[[j]] = BS_tree_trimmed_new[[j]][,3:4]
  }
  binary_tree_trimmed = list()
  binary_tree_trimmed$name = paste0("Binary Segmentation Tree Trimmed with tau = ", tau)
  for(j in 1:sum(points_at_level != 0)){
    for(k in 1:nrow(BS_tree_trimmed_new[[j]])){
      eval(parse(text=paste0("binary_tree_trimmed$",BS_tree_trimmed_new[[j]]$location[k],"$value","<-",BS_tree_trimmed_new[[j]]$value[k])))
    }
  }
  BS_tree_trimmed_node = data.tree::as.Node(binary_tree_trimmed)
  return(list(BS_tree_trimmed = BS_tree_trimmed_node, cpt_hat = change_points))
}


one.step.trim = function(idx_remove_parent, data_children){
  idx_remove_children = NULL
  for(j in idx_remove_parent){
    idx_remove_children = c(idx_remove_children, data_children$current[data_children$parent == j])
  }
  if(length(idx_remove_children) == 0){
    data_children_trimmed = data_children
  }else{
    data_children_trimmed = data_children[!(data_children$current %in% idx_remove_children),]
  }
  return(list(idx_remove_children = idx_remove_children, data_children_trimmed = data_children_trimmed))
}


############################################################ model setup 
p = 50
conn1_mat = matrix(0.1, nrow = p,ncol = p)

conn2_mat = matrix(0.3, nrow = p, ncol = p)

############################################################ edge LDP for IBN

ncpt_edge = NULL
err_edge = NULL
repn = 100
q = 0.475 #probability flip
for (n in seq(7,15,2)) {
  for (i in 1:repn) {
    obs_data_1 = t(sapply(conn1_mat[lower.tri(conn1_mat,diag = TRUE)], function (x) rbinom(n,1,x)))
    obs_data_2 = t(sapply(conn2_mat[lower.tri(conn2_mat,diag = TRUE)], function (x) rbinom(n,1,x)))
    edge_private_d1 = sbc(obs_data_1,q)
    edge_private_d2 = sbc(obs_data_2,q)
    data_mat = cbind(edge_private_d1,edge_private_d2)
    data_mat1 = data_mat[,seq(1,ncol(data_mat),2)]
    data_mat2 = data_mat[,seq(2,ncol(data_mat),2)]
    
    temp = BS.network(data_mat1,data_mat2,1,ncol(data_mat1),delta = 1)
    tau = p*(log(2*n))^{1.5}/30
    cpt_init = unlist(thresholdBS(temp, tau)$cpt_hat[,1])
    cpt = 2*cpt_init
    ncpt_edge = c(ncpt_edge,length(cpt))
    if (length(cpt) == 0){
      err_edge = c(err_edge,1)
    }else{
      err_edge = c(err_edge,Hausdorff.dist(cpt,n)/n)
    }
  }
}


M = as.data.frame(cbind(ncpt,err))
write.table(M, file=paste0('edge_ldp.csv'), sep=",",append = TRUE,row.names = FALSE)

mean_err_edge = NULL
sd_err_edge = NULL
median_err_edge = NULL

for (tt in seq(0,200,50)) {
  mean_err_edge = c(mean_err_edge,mean(err_edge[(tt+1):(tt+repn)]))
  sd_err_edge = c(sd_err_edge,sd(err_edge[(tt+1):(tt+repn)])) 
  median_err_edge = c(median_err_edge,median(err_edge[(tt+1):(tt+repn)]))
}
mean_err_edge
sd_err_edge
median_err_edge




############################################################ node LDP for bipartite IBN
ncpt = NULL
err = NULL
t0 = Sys.time()
repn = 100
for (seglength in seq(700,1500,200)) {
  #print(seglength)
  for (i in 1:repn){
    private_1 = gen_pri_node(conn_matrix = conn1_mat,seglength)
    private_2 = gen_pri_node(conn_matrix = conn2_mat,seglength)
    #private_3 = gen_pri_node(conn_matrix = conn3_mat,1000)
    data_mat = cbind(private_1, private_2)
    data_mat1 = data_mat[,seq(1,ncol(data_mat),2)]
    data_mat2 = data_mat[,seq(2,ncol(data_mat),2)]
    temp = BS.network(data_mat1,data_mat2,1,ncol(data_mat1),delta = 5)
    tau = p^2*(log(p^2*2*seglength))^2/10
    cpt_init = unlist(thresholdBS(temp, tau)$cpt_hat[,1])
    cpt = 2*cpt_init
    ncpt = c(ncpt,length(cpt))
    if (length(cpt) == 0){
      err = c(err,1)
    }else{
      err = c(err,Hausdorff.dist(cpt,seglength)/seglength)
    }
  }
}
t1 = Sys.time()-t0
t1
M = as.data.frame(cbind(ncpt,err))
write.table(M, file=paste0('node_ldp.csv'), sep=",",append = TRUE,row.names = FALSE)


mean_err = NULL
sd_err = NULL
median_err = NULL
for (tt in seq(0,200,50)) {
  mean_err = c(mean_err,mean(err[(tt+1):(tt+repn)]))
  sd_err = c(sd_err,sd(err[(tt+1):(tt+repn)]))
  median_err = c(median_err,median(err[(tt+1):(tt+repn)]))
}
mean_err
sd_err
median_err






