import argparse
import experiment
import sys

def run_experiment_algorithms(K, seed, T, d, S):
    # Feature dimension D = d * d
    D_dim = d * d
    
    algorithms = ['UCBCLB', 'UCBCCA', 'CLogUCB', 'VACLogUCB']

    print(f"{'='*60}")
    print(f"Experiment Started")
    print(f"Settings: K={K}, Seed={seed}")
    print(f"Fixed Params: T={T}, d={d} (D={D_dim}), S={S}")
    print(f"{'='*60}\n")

    # --- Run Algorithms sequentially ---
    for algo_name in algorithms:
        print(f"▶ [Running] {algo_name} ... ", end="", flush=True)
        
        experiment.run(T, K, d, S, seed, algo_name)
        
        print("Done.")

    
    print(f"\n{'='*60}")
    print("All Algorithms Completed.")
    print(f"{'='*60}")

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Run Bandit Experiments for specific K and Seed")

    parser.add_argument('--K', type=int, required=True, 
                        help='Number of recommendations (K). Example: --K 10')
    
    parser.add_argument('--seed', type=int, required=True, 
                        help='Random seed. Example: --seed 42')
    
    parser.add_argument('--T', type=int, default=10000, help='Total time steps (default: 10000)')
    parser.add_argument('--d', type=int, default=5, help='Latent dimension d (default: 5)')
    parser.add_argument('--S', type=float, default=5.0, help='Theta norm bound S (default: 5.0)')

    args = parser.parse_args()

    run_experiment_algorithms(args.K, args.seed, args.T, args.d, args.S)