# -*- coding: utf-8 -*-
# @Author  : 
# @Desc    :
import json
import asyncio

import pandas as pd

from metagpt.llm import LLM
from DABench import DABench
import json


async def ask_and_print(question, system_prompt):
    llm = LLM()
    rsp = await llm.aask(question, system_msgs=[system_prompt])
    return rsp


async def reformat(question, format, response):
    system_prompt = "You are a helpful assistant."
    demons = """
\Format{{
@shapiro_wilk_statistic[test_statistic]
@shapiro_wilk_p_value[p_value]
where "test_statistic" is a number between 0 and 1 representing the Shapiro-Wilk test statistic. Rounding off the answer to two decimal places.
where "p_value" is a number between 0 and 1 representing the p-value from the Shapiro-Wilk test. Rounding off the answer to four decimal places.
}}
\Answer{{
@shapiro_wilk_statistic[0.56]
@shapiro_wilk_p_value[0.0002]
}}

\Format{{
@total_votes_outliers_num[outlier_num]
where "outlier_num" is an integer representing the number of values considered outliers in the 'total_votes' column.
}}
\Answer{{
@total_votes_outliers[10]
}}
        """
    reformat_template = """You should strictly follow the output requirements in the Format part. Here're some examples: {demons}.
Your answer should contain all the \"@answer_name[answer]\" in the order mentioned, each \"answer\" should be in the range of value as required. You need to keep the original numbers and text, just reformat without making any changes.
The format requirements of this question is:
{format}. You need to keep the original numbers and text, just reformat without making any changes. Please give your answer:"""
    # res = """[['monthly_avg_windspeed', "{'month_1': 7.17, 'month_2': 6.53, 'month_3': 5.9, 'month_4': 6.69, 'month_5': 5.43, 'month_6': 5.82, 'month_7': 5.13, 'month_8': 5.72, 'month_9': 5.69, 'month_10': 6.57, 'month_11': 5.79, 'month_12': 5.52}"]]}"""
    messages = [{"role": "user", "content": question}]
    messages.append({"role": "assistant", "content": response})
    messages.append({"role": "user", "content": reformat_template.format(demons=demons, format=format)})
    rsp = await ask_and_print(messages, system_prompt)
    return rsp



