import numpy as np

from utils.config import parse_config_file

# parse config file
config_params = parse_config_file('gridworld.cfg')

gen_params = config_params['GENERAL']
n_tasks = gen_params['n_tasks']
n_trials = gen_params['n_trials']

task_params = config_params['TASK']
low = task_params['low']
high = task_params['high']


# generate tasks
def generate_tasks():
    return np.random.uniform(low=low, high=high, size=(n_tasks * n_trials, 3))


if __name__ == '__main__':
    np.savetxt('shapes_weights.csv', generate_tasks(), delimiter=',')
