import os

SUITE_DIR = os.path.dirname(__file__)
DMCR_VARY = ["bg", "floor", "body", "target", "reflectance", "camera", "light"]
ALL_ENVS = {}


def register(domain, task):
    def _register(func):
        if domain not in ALL_ENVS:
            ALL_ENVS[domain] = {}
        ALL_ENVS[domain][task] = func
        return func

    return _register


from .wrapper import make
from .benchmarks import classic, visual_generalization

# register all the tasks
from .fish import swim, upright
from .hopper import hop, stand
from .humanoid import run, stand, walk
from .pendulum import swingup
from .cartpole import balance, balance_sparse, swingup, swingup_sparse
from .walker import run, stand, walk
from .cheetah import run
from .finger import spin, turn_hard, turn_easy
from .reacher import easy, hard
from .ball_in_cup import catch
from .swimmer import swimmer6, swimmer15

from .walker import get_model
from .generate_visuals import get_assets
