/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.EventType;
import engine.helper.SpriteType;
import java.awt.Graphics;

public class FireFlower
extends MarioSprite {
    private MarioImage graphics;
    private int life;

    public FireFlower(boolean bl, float f, float f2) {
        super(f, f2, SpriteType.FIRE_FLOWER);
        this.width = 4;
        this.height = 12;
        this.facing = 1;
        this.life = 0;
        if (bl) {
            this.graphics = new MarioImage(Assets.items, 1);
            this.graphics.originX = 8;
            this.graphics.originY = 15;
            this.graphics.width = 16;
            this.graphics.height = 16;
        }
    }

    @Override
    public MarioSprite clone() {
        FireFlower fireFlower = new FireFlower(false, this.x, this.y);
        fireFlower.xa = this.xa;
        fireFlower.ya = this.ya;
        fireFlower.initialCode = this.initialCode;
        fireFlower.width = this.width;
        fireFlower.height = this.height;
        fireFlower.facing = this.facing;
        fireFlower.life = this.life;
        return fireFlower;
    }

    @Override
    public void collideCheck() {
        if (!this.alive) {
            return;
        }
        float f = this.world.mario.x - this.x;
        float f2 = this.world.mario.y - this.y;
        if (f > -16.0f && f < 16.0f && f2 > (float)(-this.height) && f2 < (float)this.world.mario.height) {
            this.world.addEvent(EventType.COLLECT, this.type.getValue());
            this.world.mario.getFlower();
            this.world.removeSprite(this);
        }
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        super.update();
        ++this.life;
        if (this.life < 9) {
            this.y -= 1.0f;
            return;
        }
        if (this.graphics != null) {
            this.graphics.index = 1 + this.life / 2 % 2;
        }
    }

    @Override
    public void render(Graphics graphics) {
        super.render(graphics);
        this.graphics.render(graphics, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
    }
}

