/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.effects.DeathEffect;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.EventType;
import engine.helper.SpriteType;
import engine.sprites.Fireball;
import java.awt.Graphics;

public class Shell
extends MarioSprite {
    private static final float GROUND_INERTIA = 0.89f;
    private static final float AIR_INERTIA = 0.89f;
    private int shellType = 0;
    private boolean onGround = false;
    private MarioImage graphics;

    public Shell(boolean bl, float f, float f2, int n, String string) {
        super(f, f2, SpriteType.SHELL);
        this.width = 4;
        this.height = 12;
        this.facing = 0;
        this.ya = -5.0f;
        this.shellType = n;
        this.initialCode = string;
        if (bl) {
            this.graphics = new MarioImage(Assets.enemies, n * 8 + 3);
            this.graphics.originX = 8;
            this.graphics.originY = 31;
            this.graphics.width = 16;
        }
    }

    @Override
    public MarioSprite clone() {
        Shell shell = new Shell(false, this.x, this.y, this.shellType, this.initialCode);
        shell.xa = this.xa;
        shell.ya = this.ya;
        shell.width = this.width;
        shell.height = this.height;
        shell.facing = this.facing;
        shell.onGround = this.onGround;
        return shell;
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        super.update();
        float f = 11.0f;
        if (this.xa > 2.0f) {
            this.facing = 1;
        }
        if (this.xa < -2.0f) {
            this.facing = -1;
        }
        this.xa = (float)this.facing * f;
        if (this.facing != 0) {
            this.world.checkShellCollide(this);
        }
        if (!this.move(this.xa, 0.0f)) {
            this.facing = -this.facing;
        }
        this.onGround = false;
        this.move(0.0f, this.ya);
        this.ya *= 0.85f;
        this.xa = this.onGround ? (this.xa *= 0.89f) : (this.xa *= 0.89f);
        if (!this.onGround) {
            this.ya += 2.0f;
        }
        if (this.graphics != null) {
            this.graphics.flipX = this.facing == -1;
        }
    }

    @Override
    public void render(Graphics graphics) {
        super.render(graphics);
        this.graphics.render(graphics, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
    }

    @Override
    public boolean fireballCollideCheck(Fireball fireball) {
        if (!this.alive) {
            return false;
        }
        float f = fireball.x - this.x;
        float f2 = fireball.y - this.y;
        if (f > -16.0f && f < 16.0f && f2 > (float)(-this.height) && f2 < (float)fireball.height) {
            if (this.facing != 0) {
                return true;
            }
            this.xa = fireball.facing * 2;
            this.ya = -5.0f;
            if (this.graphics != null) {
                this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 41 + this.shellType, -5.0f));
            }
            this.world.removeSprite(this);
            return true;
        }
        return false;
    }

    @Override
    public void collideCheck() {
        if (!this.alive) {
            return;
        }
        float f = this.world.mario.x - this.x;
        float f2 = this.world.mario.y - this.y;
        if (f > -16.0f && f < 16.0f && f2 > (float)(-this.height) && f2 < (float)this.world.mario.height) {
            if (this.world.mario.ya > 0.0f && f2 <= 0.0f && (!this.world.mario.onGround || !this.world.mario.wasOnGround)) {
                this.world.mario.stomp(this);
                if (this.facing != 0) {
                    this.xa = 0.0f;
                    this.facing = 0;
                } else {
                    this.facing = this.world.mario.facing;
                }
            } else if (this.facing != 0) {
                this.world.addEvent(EventType.HURT, this.type.getValue());
                this.world.mario.getHurt();
            } else {
                this.world.addEvent(EventType.KICK, this.type.getValue());
                this.world.mario.kick(this);
                this.facing = this.world.mario.facing;
            }
        }
    }

    private boolean move(float f, float f2) {
        while (f > 8.0f) {
            if (!this.move(8.0f, 0.0f)) {
                return false;
            }
            f -= 8.0f;
        }
        while (f < -8.0f) {
            if (!this.move(-8.0f, 0.0f)) {
                return false;
            }
            f += 8.0f;
        }
        while (f2 > 8.0f) {
            if (!this.move(0.0f, 8.0f)) {
                return false;
            }
            f2 -= 8.0f;
        }
        while (f2 < -8.0f) {
            if (!this.move(0.0f, -8.0f)) {
                return false;
            }
            f2 += 8.0f;
        }
        boolean bl = false;
        if (f2 > 0.0f) {
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2, f, 0.0f)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + (float)this.width, this.y + f2, f, 0.0f)) {
                bl = true;
            } else if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 + 1.0f, f, f2)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 + 1.0f, f, f2)) {
                bl = true;
            }
        }
        if (f2 < 0.0f) {
            if (this.isBlocking(this.x + f, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
        }
        if (f > 0.0f) {
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)(this.height / 2), f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2, f, f2)) {
                bl = true;
            }
        }
        if (f < 0.0f) {
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)(this.height / 2), f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2, f, f2)) {
                bl = true;
            }
        }
        if (bl) {
            if (f < 0.0f) {
                this.x = (int)((this.x - (float)this.width) / 16.0f) * 16 + this.width;
                this.xa = 0.0f;
            }
            if (f > 0.0f) {
                this.x = (int)((this.x + (float)this.width) / 16.0f + 1.0f) * 16 - this.width - 1;
                this.xa = 0.0f;
            }
            if (f2 < 0.0f) {
                this.y = (int)((this.y - (float)this.height) / 16.0f) * 16 + this.height;
                this.ya = 0.0f;
            }
            if (f2 > 0.0f) {
                this.y = (int)(this.y / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += f;
        this.y += f2;
        return true;
    }

    private boolean isBlocking(float f, float f2, float f3, float f4) {
        int n = (int)(f / 16.0f);
        int n2 = (int)(f2 / 16.0f);
        if (n == (int)(this.x / 16.0f) && n2 == (int)(this.y / 16.0f)) {
            return false;
        }
        boolean bl = this.world.level.isBlocking(n, n2, f3, f4);
        if (bl && f4 == 0.0f && f3 != 0.0f) {
            this.world.bump(n, n2, true);
        }
        return bl;
    }

    @Override
    public void bumpCheck(int n, int n2) {
        if (!this.alive) {
            return;
        }
        if (this.x + (float)this.width > (float)(n * 16) && this.x - (float)this.width < (float)(n * 16 + 16) && n2 == (int)((this.y - 1.0f) / 16.0f)) {
            this.facing = -this.world.mario.facing;
            this.ya = -10.0f;
        }
    }

    @Override
    public boolean shellCollideCheck(Shell shell) {
        if (!this.alive) {
            return false;
        }
        float f = shell.x - this.x;
        float f2 = shell.y - this.y;
        if (f > -16.0f && f < 16.0f && f2 > (float)(-this.height) && f2 < (float)shell.height) {
            this.world.addEvent(EventType.SHELL_KILL, this.type.getValue());
            if (this != shell) {
                this.world.removeSprite(shell);
            }
            this.world.removeSprite(this);
            return true;
        }
        return false;
    }
}

