/*
 * Decompiled with CFR 0.152.
 */
import agents.human.Agent;
import engine.core.MarioGame;
import engine.core.MarioResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class PlayLevel {
    public static void printResults(MarioResult marioResult) {
        System.out.println("****************************************************************");
        System.out.println("Game Status: " + marioResult.getGameStatus().toString() + " Percentage Completion: " + marioResult.getCompletionPercentage());
        System.out.println("Lives: " + marioResult.getCurrentLives() + " Coins: " + marioResult.getCurrentCoins() + " Remaining Time: " + (int)Math.ceil((float)marioResult.getRemainingTime() / 1000.0f));
        System.out.println("Mario State: " + marioResult.getMarioMode() + " (Mushrooms: " + marioResult.getNumCollectedMushrooms() + " Fire Flowers: " + marioResult.getNumCollectedFireflower() + ")");
        System.out.println("Total Kills: " + marioResult.getKillsTotal() + " (Stomps: " + marioResult.getKillsByStomp() + " Fireballs: " + marioResult.getKillsByFire() + " Shells: " + marioResult.getKillsByShell() + " Falls: " + marioResult.getKillsByFall() + ")");
        System.out.println("Bricks: " + marioResult.getNumDestroyedBricks() + " Jumps: " + marioResult.getNumJumps() + " Max X Jump: " + marioResult.getMaxXJump() + " Max Air Time: " + marioResult.getMaxJumpAirTime());
        System.out.println("****************************************************************");
    }

    public static String getLevel(String string) {
        String string2 = "";
        try {
            string2 = new String(Files.readAllBytes(Paths.get(string, new String[0])));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    public static void playLevel(MarioGame marioGame, String string) {
        System.out.println("Running Interactive Play!");
        System.out.println("=========================");
        PlayLevel.printResults(marioGame.playInteractive(new Agent(), PlayLevel.getLevel(string), 200, 999));
    }

    public static void playLevel(MarioGame marioGame, String string, String string2) {
        System.out.println("Running Interactive Play!");
        System.out.println("=========================");
        PlayLevel.printResults(marioGame.playInteractive(new Agent(), PlayLevel.getLevel(string), 200, 999, string2));
    }

    public static void main(String[] stringArray) {
        MarioGame marioGame = new MarioGame();
        String string = stringArray[0];
        if (stringArray.length == 2) {
            String string2 = stringArray[1];
            PlayLevel.playLevel(marioGame, string, string2);
        } else {
            PlayLevel.playLevel(marioGame, string);
        }
    }
}

