/*
 * Decompiled with CFR 0.152.
 */
package agents.robinBaumgarten;

import agents.robinBaumgarten.SearchNode;
import engine.core.MarioForwardModel;
import engine.helper.GameStatus;
import engine.helper.MarioActions;
import java.util.ArrayList;

public class Helper {
    public static final int visitedListPenalty = 1500;
    public static final float maxMarioSpeed = 10.909091f;

    public static int getMarioDamage(MarioForwardModel marioForwardModel, MarioForwardModel marioForwardModel2) {
        int n = 0;
        if (marioForwardModel2.getMarioMode() > marioForwardModel.getMarioMode()) {
            ++n;
        }
        if (marioForwardModel.getGameStatus() == GameStatus.LOSE) {
            n = marioForwardModel.getMarioFloatPos()[1] > marioForwardModel.getLevelFloatDimensions()[1] - 20.0f ? (n += 5) : (n += 2);
        }
        return n;
    }

    public static String getActionString(boolean[] blArray) {
        String string = "";
        if (blArray[MarioActions.RIGHT.getValue()]) {
            string = string + "Forward ";
        }
        if (blArray[MarioActions.LEFT.getValue()]) {
            string = string + "Backward ";
        }
        if (blArray[MarioActions.SPEED.getValue()]) {
            string = string + "Speed ";
        }
        if (blArray[MarioActions.JUMP.getValue()]) {
            string = string + "Jump ";
        }
        if (blArray[MarioActions.DOWN.getValue()]) {
            string = string + "Duck";
        }
        if (string.length() == 0) {
            string = "[NONE]";
        }
        return string;
    }

    public static float[] estimateMaximumForwardMovement(float f, boolean[] blArray, int n) {
        float f2 = 0.0f;
        float f3 = blArray[MarioActions.SPEED.getValue()] ? 1.2f : 0.6f;
        int n2 = 0;
        if (blArray[MarioActions.LEFT.getValue()]) {
            n2 = -1;
        }
        if (blArray[MarioActions.RIGHT.getValue()]) {
            n2 = 1;
        }
        for (int i = 0; i < n; ++i) {
            f2 += (f += f3 * (float)n2);
            f *= 0.89f;
        }
        float[] fArray = new float[]{f2, f};
        return fArray;
    }

    public static boolean[] createAction(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        boolean[] blArray = new boolean[5];
        blArray[MarioActions.DOWN.getValue()] = bl3;
        blArray[MarioActions.JUMP.getValue()] = bl4;
        blArray[MarioActions.LEFT.getValue()] = bl;
        blArray[MarioActions.RIGHT.getValue()] = bl2;
        blArray[MarioActions.SPEED.getValue()] = bl5;
        return blArray;
    }

    public static boolean canJumpHigher(SearchNode searchNode, boolean bl) {
        if (searchNode.parentPos != null && bl && Helper.canJumpHigher(searchNode.parentPos, false)) {
            return true;
        }
        return searchNode.sceneSnapshot.mayMarioJump() || searchNode.sceneSnapshot.getMarioCanJumpHigher();
    }

    public static ArrayList<boolean[]> createPossibleActions(SearchNode searchNode) {
        ArrayList<boolean[]> arrayList = new ArrayList<boolean[]>();
        if (Helper.canJumpHigher(searchNode, true)) {
            arrayList.add(Helper.createAction(false, false, false, true, false));
        }
        if (Helper.canJumpHigher(searchNode, true)) {
            arrayList.add(Helper.createAction(false, false, false, true, true));
        }
        arrayList.add(Helper.createAction(false, true, false, false, true));
        if (Helper.canJumpHigher(searchNode, true)) {
            arrayList.add(Helper.createAction(false, true, false, true, true));
        }
        arrayList.add(Helper.createAction(false, true, false, false, false));
        if (Helper.canJumpHigher(searchNode, true)) {
            arrayList.add(Helper.createAction(false, true, false, true, false));
        }
        arrayList.add(Helper.createAction(true, false, false, false, false));
        if (Helper.canJumpHigher(searchNode, true)) {
            arrayList.add(Helper.createAction(true, false, false, true, false));
        }
        arrayList.add(Helper.createAction(true, false, false, false, true));
        if (Helper.canJumpHigher(searchNode, true)) {
            arrayList.add(Helper.createAction(true, false, false, true, true));
        }
        return arrayList;
    }
}

