/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.effects.DeathEffect;
import engine.effects.SquishEffect;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.EventType;
import engine.helper.SpriteType;
import engine.sprites.Fireball;
import engine.sprites.Shell;
import java.awt.Graphics;

public class Enemy
extends MarioSprite {
    private static final float GROUND_INERTIA = 0.89f;
    private static final float AIR_INERTIA = 0.89f;
    protected boolean onGround = false;
    protected boolean avoidCliffs = true;
    protected boolean winged = true;
    protected boolean noFireballDeath;
    protected float runTime;
    protected int wingTime = 0;
    protected MarioImage wingGraphics;
    protected MarioImage graphics;

    public Enemy(boolean bl, float f, float f2, int n, SpriteType spriteType) {
        super(f, f2, spriteType);
        this.width = 4;
        this.height = 24;
        if (this.type != SpriteType.RED_KOOPA && this.type != SpriteType.GREEN_KOOPA && this.type != SpriteType.RED_KOOPA_WINGED && this.type != SpriteType.GREEN_KOOPA_WINGED) {
            this.height = 12;
        }
        this.winged = this.type.getValue() % 2 == 1;
        this.avoidCliffs = this.type == SpriteType.RED_KOOPA || this.type == SpriteType.RED_KOOPA_WINGED;
        this.noFireballDeath = this.type == SpriteType.SPIKY || this.type == SpriteType.SPIKY_WINGED;
        this.facing = n;
        if (this.facing == 0) {
            this.facing = 1;
        }
        if (bl) {
            this.graphics = new MarioImage(Assets.enemies, this.type.getStartIndex());
            this.graphics.originX = 8;
            this.graphics.originY = 31;
            this.graphics.width = 16;
            this.wingGraphics = new MarioImage(Assets.enemies, 32);
            this.wingGraphics.originX = 16;
            this.wingGraphics.originY = 31;
            this.wingGraphics.width = 16;
        }
    }

    @Override
    public MarioSprite clone() {
        Enemy enemy = new Enemy(false, this.x, this.y, this.facing, this.type);
        enemy.xa = this.xa;
        enemy.ya = this.ya;
        enemy.initialCode = this.initialCode;
        enemy.width = this.width;
        enemy.height = this.height;
        enemy.onGround = this.onGround;
        enemy.winged = this.winged;
        enemy.avoidCliffs = this.avoidCliffs;
        enemy.noFireballDeath = this.noFireballDeath;
        return enemy;
    }

    @Override
    public void collideCheck() {
        if (!this.alive) {
            return;
        }
        float f = this.world.mario.x - this.x;
        float f2 = this.world.mario.y - this.y;
        if (f > (float)(-this.width * 2 - 4) && f < (float)(this.width * 2 + 4) && f2 > (float)(-this.height) && f2 < (float)this.world.mario.height) {
            if (this.type != SpriteType.SPIKY && this.type != SpriteType.SPIKY_WINGED && this.type != SpriteType.ENEMY_FLOWER && this.world.mario.ya > 0.0f && f2 <= 0.0f && (!this.world.mario.onGround || !this.world.mario.wasOnGround)) {
                this.world.mario.stomp(this);
                if (this.winged) {
                    this.winged = false;
                    this.ya = 0.0f;
                } else {
                    if (this.type == SpriteType.GREEN_KOOPA || this.type == SpriteType.GREEN_KOOPA_WINGED) {
                        this.world.addSprite(new Shell(this.graphics != null, this.x, this.y, 1, this.initialCode));
                    } else if (this.type == SpriteType.RED_KOOPA || this.type == SpriteType.RED_KOOPA_WINGED) {
                        this.world.addSprite(new Shell(this.graphics != null, this.x, this.y, 0, this.initialCode));
                    } else if ((this.type == SpriteType.GOOMBA || this.type == SpriteType.GOOMBA_WINGED) && this.graphics != null) {
                        this.world.addEffect(new SquishEffect(this.x, this.y - 7.0f));
                    }
                    this.world.addEvent(EventType.STOMP_KILL, this.type.getValue());
                    this.world.removeSprite(this);
                }
            } else {
                this.world.addEvent(EventType.HURT, this.type.getValue());
                this.world.mario.getHurt();
            }
        }
    }

    private void updateGraphics() {
        ++this.wingTime;
        this.wingGraphics.index = 32 + this.wingTime / 4 % 2;
        this.graphics.flipX = this.facing == -1;
        this.runTime += Math.abs(this.xa) + 5.0f;
        int n = (int)(this.runTime / 20.0f) % 2;
        if (!this.onGround) {
            n = 1;
        }
        if (this.winged) {
            n = this.wingTime / 4 % 2;
        }
        this.graphics.index = this.type.getStartIndex() + n;
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        float f = 1.75f;
        if (this.xa > 2.0f) {
            this.facing = 1;
        }
        if (this.xa < -2.0f) {
            this.facing = -1;
        }
        this.xa = (float)this.facing * f;
        if (!this.move(this.xa, 0.0f)) {
            this.facing = -this.facing;
        }
        this.onGround = false;
        this.move(0.0f, this.ya);
        this.ya *= this.winged ? 0.95f : 0.85f;
        this.xa = this.onGround ? (this.xa *= 0.89f) : (this.xa *= 0.89f);
        if (!this.onGround) {
            this.ya = this.winged ? (this.ya += 0.6f) : (this.ya += 2.0f);
        } else if (this.winged) {
            this.ya = -10.0f;
        }
        if (this.graphics != null) {
            this.updateGraphics();
        }
    }

    private boolean move(float f, float f2) {
        while (f > 8.0f) {
            if (!this.move(8.0f, 0.0f)) {
                return false;
            }
            f -= 8.0f;
        }
        while (f < -8.0f) {
            if (!this.move(-8.0f, 0.0f)) {
                return false;
            }
            f += 8.0f;
        }
        while (f2 > 8.0f) {
            if (!this.move(0.0f, 8.0f)) {
                return false;
            }
            f2 -= 8.0f;
        }
        while (f2 < -8.0f) {
            if (!this.move(0.0f, -8.0f)) {
                return false;
            }
            f2 += 8.0f;
        }
        boolean bl = false;
        if (f2 > 0.0f) {
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2, f, 0.0f)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + (float)this.width, this.y + f2, f, 0.0f)) {
                bl = true;
            } else if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 + 1.0f, f, f2)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 + 1.0f, f, f2)) {
                bl = true;
            }
        }
        if (f2 < 0.0f) {
            if (this.isBlocking(this.x + f, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
        }
        if (f > 0.0f) {
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)(this.height / 2), f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2, f, f2)) {
                bl = true;
            }
            if (this.avoidCliffs && this.onGround && !this.world.level.isBlocking((int)((this.x + f + (float)this.width) / 16.0f), (int)(this.y / 16.0f + 1.0f), f, 1.0f)) {
                bl = true;
            }
        }
        if (f < 0.0f) {
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)(this.height / 2), f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2, f, f2)) {
                bl = true;
            }
            if (this.avoidCliffs && this.onGround && !this.world.level.isBlocking((int)((this.x + f - (float)this.width) / 16.0f), (int)(this.y / 16.0f + 1.0f), f, 1.0f)) {
                bl = true;
            }
        }
        if (bl) {
            if (f < 0.0f) {
                this.x = (int)((this.x - (float)this.width) / 16.0f) * 16 + this.width;
                this.xa = 0.0f;
            }
            if (f > 0.0f) {
                this.x = (int)((this.x + (float)this.width) / 16.0f + 1.0f) * 16 - this.width - 1;
                this.xa = 0.0f;
            }
            if (f2 < 0.0f) {
                this.y = (int)((this.y - (float)this.height) / 16.0f) * 16 + this.height;
                this.ya = 0.0f;
            }
            if (f2 > 0.0f) {
                this.y = (int)(this.y / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += f;
        this.y += f2;
        return true;
    }

    private boolean isBlocking(float f, float f2, float f3, float f4) {
        int n = (int)(f / 16.0f);
        int n2 = (int)(f2 / 16.0f);
        if (n == (int)(this.x / 16.0f) && n2 == (int)(this.y / 16.0f)) {
            return false;
        }
        boolean bl = this.world.level.isBlocking(n, n2, f3, f4);
        return bl;
    }

    @Override
    public boolean shellCollideCheck(Shell shell) {
        if (!this.alive) {
            return false;
        }
        float f = shell.x - this.x;
        float f2 = shell.y - this.y;
        if (f > -16.0f && f < 16.0f && f2 > (float)(-this.height) && f2 < (float)shell.height) {
            this.xa = shell.facing * 2;
            this.ya = -5.0f;
            this.world.addEvent(EventType.SHELL_KILL, this.type.getValue());
            if (this.graphics != null) {
                if (this.type == SpriteType.GREEN_KOOPA || this.type == SpriteType.GREEN_KOOPA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 42, -5.0f));
                } else if (this.type == SpriteType.RED_KOOPA || this.type == SpriteType.RED_KOOPA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 41, -5.0f));
                } else if (this.type == SpriteType.GOOMBA || this.type == SpriteType.GOOMBA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 44, -5.0f));
                } else if (this.type == SpriteType.SPIKY || this.type == SpriteType.SPIKY_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 45, -5.0f));
                }
            }
            this.world.removeSprite(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean fireballCollideCheck(Fireball fireball) {
        if (!this.alive) {
            return false;
        }
        float f = fireball.x - this.x;
        float f2 = fireball.y - this.y;
        if (f > -16.0f && f < 16.0f && f2 > (float)(-this.height) && f2 < (float)fireball.height) {
            if (this.noFireballDeath) {
                return true;
            }
            this.xa = fireball.facing * 2;
            this.ya = -5.0f;
            this.world.addEvent(EventType.FIRE_KILL, this.type.getValue());
            if (this.graphics != null) {
                if (this.type == SpriteType.GREEN_KOOPA || this.type == SpriteType.GREEN_KOOPA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 42, -5.0f));
                } else if (this.type == SpriteType.RED_KOOPA || this.type == SpriteType.RED_KOOPA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 41, -5.0f));
                } else if (this.type == SpriteType.GOOMBA || this.type == SpriteType.GOOMBA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 44, -5.0f));
                }
            }
            this.world.removeSprite(this);
            return true;
        }
        return false;
    }

    @Override
    public void bumpCheck(int n, int n2) {
        if (!this.alive) {
            return;
        }
        if (this.x + (float)this.width > (float)(n * 16) && this.x - (float)this.width < (float)(n * 16 + 16) && n2 == (int)((this.y - 1.0f) / 16.0f)) {
            this.xa = -this.world.mario.facing * 2;
            this.ya = -5.0f;
            if (this.graphics != null) {
                if (this.type == SpriteType.GREEN_KOOPA || this.type == SpriteType.GREEN_KOOPA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 42, -5.0f));
                } else if (this.type == SpriteType.RED_KOOPA || this.type == SpriteType.RED_KOOPA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 41, -5.0f));
                } else if (this.type == SpriteType.GOOMBA || this.type == SpriteType.GOOMBA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 44, -5.0f));
                } else if (this.type == SpriteType.SPIKY || this.type == SpriteType.SPIKY_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 45, -5.0f));
                }
            }
            this.world.removeSprite(this);
        }
    }

    @Override
    public void render(Graphics graphics) {
        if (this.winged && this.type != SpriteType.RED_KOOPA && this.type != SpriteType.GREEN_KOOPA && this.type != SpriteType.RED_KOOPA_WINGED && this.type != SpriteType.GREEN_KOOPA_WINGED) {
            this.wingGraphics.flipX = false;
            this.wingGraphics.render(graphics, (int)(this.x - this.world.cameraX - 6.0f), (int)(this.y - this.world.cameraY - 6.0f));
            this.wingGraphics.flipX = true;
            this.wingGraphics.render(graphics, (int)(this.x - this.world.cameraX + 22.0f), (int)(this.y - this.world.cameraY - 6.0f));
        }
        this.graphics.render(graphics, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
        if (this.winged && (this.type == SpriteType.RED_KOOPA || this.type == SpriteType.GREEN_KOOPA || this.type == SpriteType.RED_KOOPA_WINGED || this.type == SpriteType.GREEN_KOOPA_WINGED)) {
            int n = -1;
            if (this.graphics.flipX) {
                n = 17;
            }
            this.wingGraphics.flipX = this.graphics.flipX;
            this.wingGraphics.render(graphics, (int)(this.x - this.world.cameraX + (float)n), (int)(this.y - this.world.cameraY - 8.0f));
        }
    }
}

