# -*- coding: utf-8 -*-

from opencood.data_utils.datasets.intermediate_fusion_dataset_v2xreal import IntermediateFusionDatasetV2XReal
from opencood.data_utils.datasets.intermediate_fusion_dataset_v2xsim import IntermediateFusionDatasetV2XSim

__all__ = {
    'IntermediateFusionDatasetV2XReal': IntermediateFusionDatasetV2XReal,
    'IntermediateFusionDatasetV2XSim': IntermediateFusionDatasetV2XSim,
}

# the final range for evaluation
# GT_RANGE = [-102.4, -102.4, -6, 102.4, 102.4, 3]
# GT_RANGE = [-202.4, -202.4, -7, 202.4, 202.4, 2]
GT_RANGE = [-100, -40, -15, 100, 40, 15]
# GT_RANGE = [-70, -70, -7, 70, 70, 4]
# GT_RANGE = [-51.2, -51.2, -5, 51.2, 51.2, 2]
# The communication range for cavs
COM_RANGE = 60


def build_dataset(dataset_cfg, visualize=False, train=True):
    dataset_name = dataset_cfg['fusion']['core_method']
    error_message = f"{dataset_name} is not found. " \
                    f"Please add your processor file's name in opencood/" \
                    f"data_utils/datasets/init.py"
    assert dataset_name in __all__.keys(), error_message

    dataset = __all__[dataset_name](
        params=dataset_cfg,
        visualize=visualize,
        train=train
    )

    return dataset
