# -*- coding: utf-8 -*-

from opencood.data_utils.post_processor.bev_postprocessor import BevPostprocessor

__all__ = {
    'BevPostprocessor': BevPostprocessor,
}


def build_postprocessor(anchor_cfg, class_names, train):
    process_method_name = anchor_cfg['core_method']
    assert process_method_name in ['BevPostprocessor']
    anchor_generator = __all__[process_method_name](
        anchor_params=anchor_cfg,
        class_names=class_names,
        train=train
    )

    return anchor_generator
