import os
import subprocess
from train_original import get_conv_val
import pickle


batch = 1
h1,h2,h3 = 8,8,6
lam = 0.4
N,card,r,mse = 200,30,2.0,0.02

with open('/home/jlong/NeuraLayout/original_results/best_params.pickle','rb') as f:
    best_conv_val,best_train_lr,best_optim = pickle.load(f)
print('best_conv_val:',best_conv_val)
print('best_train_lr:',best_train_lr)
print('best_optim:',best_optim)

# first obtain conv_val
for optim in ['Adam','RMSProp','SGD']:
    for prefit_lr in [0.01,0.05,0.1]:
        for train_lr in [0.005,0.01,0.05,0.1]:
    
            for k in range(5):
                subprocess.run([
                        "python", "/home/jlong/NeuraLayout/src/train_GCN.py", 
                        "/home/jlong/NeuraLayout/GCN_2L_results/{}_{}pt_bat{}_card{}_r{}_H{}{}{}_plr{}_tlr{}_{}".format(optim,N,batch,card,r,h1,h2,h3,prefit_lr,train_lr,k),
                        "--N={}".format(N),
                        "--range={}".format(r),
                        "--card={}".format(card),
                        "--prefit_lr={}".format(prefit_lr),
                        "--train_lr={}".format(train_lr),
                        "--optim={}".format(optim),
                        "--lam={}".format(lam),
                        "--h1={}".format(h1),"--h2={}".format(h2),"--h3={}".format(h3),
                        "--max_fit_epoch=200",
                        "--mse_thresh={}".format(mse),
                        "--max_train_epoch=1000",
                        "--conv_patience=100",
                        "--conv_thresh=0.03",
                        "--conv_val={}".format(best_conv_val),
                        "--switch_patience=15"
                        ])