import os
import subprocess
import time
from train_original import get_conv_val
import pickle

# os.system("python train_original.py model_results2/original_adam --max_train_epoch=10 --conv_thresh=0.02")

# for i in [2,3,4,5]:
#     thr = 0.01*i
#     subprocess.run([
#                     "python", 
#                     "train_original.py", 
#                     "original_adam_results/thr00{}".format(i),
#                     "--N=150",
#                     "--max_train_epoch=1000",
#                     "--conv_thresh={:f}".format(thr)
#                     ])

# 200 point cloud
batch = 1
start_time = time.time()
N,card,r = 200,30,2.0

best_optim = None
best_train_lr = None
best_conv_val = None

for optim in ['SGD']:
    for train_lr in [0.005,0.01,0.05,0.1]:

        subprocess.run([
                "python", 
                "/home/jlong/NeuraLayout/src/train_original.py", 
                "/home/jlong/NeuraLayout/original_results/{}_{}pt_1000eps_bat{}_card{}_r{}_tlr{}".format(
                    optim,N,batch,card,r,train_lr
                ),
                "--N={}".format(N),
                "--range={}".format(r),
                "--card={}".format(card),
                "--train_lr={}".format(train_lr),
                "--optim={}".format(optim),
                "--max_train_epoch=1000",
                "--conv_thresh={:f}".format(0.001)
                ])
        with open("/home/jlong/NeuraLayout/original_results/{}_{}pt_1000eps_bat{}_card{}_r{}_tlr{}_train_result_regular.pickle".format(
                    optim,N,batch,card,r,train_lr
                ),'rb') as f:
            original_loss,_,_ = pickle.load(f)
        conv_val = get_conv_val(original_loss)
        
        if best_conv_val is None or conv_val < best_conv_val:
            best_conv_val = conv_val
            best_train_lr = train_lr
            best_optim = optim
            print('best_conv_val:',best_conv_val)

with open('/home/jlong/NeuraLayout/original_results/best_params.pickle','wb') as f:
    pickle.dump([best_conv_val,best_train_lr,best_optim],f)
        
print("time used: {} s".format(time.time()-start_time))



    
