"""node for rollout context tree"""
from dataclasses import dataclass, field
from typing import List, Optional, Dict, Union

@dataclass
class Node:
    # parameters of system1
    system1_message: Optional[List[dict]] = None
    system1_output: Optional[str] = None # used for tool results
    system1_output_format: Optional[bool] = None
    tool_role_message: Optional[dict] = None
    # parameters of system2
    system2_message: Optional[List[dict]] = None
    system2_output: Optional[str] = None 
    # tool part
    tool: Optional[Dict] = None
    tool_json: Optional[Dict] = None  # tool params
    tool_output: Optional[str] = None
    # answer part
    answer_tag_part: Optional[str] = None
    boxed_answer: Optional[str] = None
    # node status
    valid: Optional[bool] = None
    end: bool = False
    stop_reason: Optional[str] = None
    
