import os
import re
from typing import Tuple, Union

TOOL_RESPONSE_TAG = None if os.getenv('TOOL_RESPONSE_TAG', 'tool_response').lower() == "none" else os.getenv('TOOL_RESPONSE_TAG', 'tool_response')

from .base import BaseSystem

class System1(BaseSystem):
# class System1():
    def __init__(self, **kwargs):
        super().__init__(**kwargs)
    
    @staticmethod
    def parse_output(text:str, mode: str):
        if mode == "online":
            if TOOL_RESPONSE_TAG is not None:
                text = text.lstrip(f'<{TOOL_RESPONSE_TAG}>').rstrip(f'</{TOOL_RESPONSE_TAG}>').strip()
                return f'<{TOOL_RESPONSE_TAG}>\n{text}\n</{TOOL_RESPONSE_TAG}>', None
            else:
                return text.strip(), None

        elif mode == "training":
            # tool_role_content = text.lstrip('<tool_response>').rstrip('</tool_response>')
            return text, System1.check_format(text)
        else: # None
            raise ValueError("mode must be 'online' or 'training' for parse_output")
    
    @staticmethod
    def check_format(text):
        if TOOL_RESPONSE_TAG is None: # 不检查
            return True
        # try: 
        pattern = r'^<{tag}>(?:(?!<{tag}>|</{tag}>).)*</{tag}>$'.format(tag=TOOL_RESPONSE_TAG)
        return bool(re.match(pattern, text, re.DOTALL))
        # except Exception as e:
        #     print("=== Parse Output Debug Info ===")
        #     print(f"Error in parse_output: {str(e)}")
        #     print(f"Input text type: {type(text)}")
        #     print(f"Input text content: {text}")       
        #     print("============================")
        #     raise

if __name__=="__main__":
    # 测试
    test_strings = [
        '<tool_response>这是正确的格式</tool_response>',
        '<tool_response>嵌套的<tool_response>不正确</tool_response>',
        '<tool_response>嵌套的</tool_response>不正确</tool_response>',
        'missing tags',
        '<tool_response>未闭合',
        '错误的位置</tool_response>',
    ]

    for s in test_strings:
        print(f"'{s}': {System1.check_format(s)}")
