from typing import Optional

class ToolServiceError(Exception):

    def __init__(self,
                 exception: Optional[Exception] = None,
                 code: Optional[str] = None,
                 message: Optional[str] = None,
                 extra: Optional[dict] = None):
        if exception is not None:
            super().__init__(exception)
        else:
            super().__init__(f'\nError code: {code}. Error message: {message}')
        self.exception = exception
        self.code = code
        self.message = message
        self.extra = extra

def init_tools(config):
    """return tools and functions_desc"""
    from deep_search.tools import GoogleSearch
    
    tools = {}
    googlesearch = GoogleSearch(config.tools.googlesearch)
    tools['GoogleSearch'] = googlesearch
    functions_desc = [googlesearch.function]

    return tools, functions_desc
