import os
TOOL_VERSION = os.getenv('TOOL_VERSION', 'en_v3')

PURPOSE_DICT = {
    'en_v1': "Purpose",
    'en_v2': "Objective",
    'en_v3': "Purpose",
    'en_v3_code': "Purpose",
}

def func_input_desc(tool: dict):
    return """{purpose_key}: {purpose}\nTool Name: {tool_name}\nArguments: {args}""".format(
        purpose_key=PURPOSE_DICT[TOOL_VERSION],
        purpose=tool['purpose'],
        tool_name=tool['tool_name'],
        args=tool['tool_args']
    )

def readpage_func_desc(tool: dict):
    return """# User {purpose_key}: {purpose}\n""".format(
        purpose_key=PURPOSE_DICT[TOOL_VERSION],
        purpose=tool['purpose'],
    )