# /usr/bin/env python
# -*- coding: utf-8 -*-

from online.estimator.accous import Accous
from online.estimator.base import *
from online.estimator.olr import OLR

def get_estimator_alg(cfgs, model, train_set, device, rng, info):

    alg_kwargs = {
        'model': model,
        'dataset': train_set,
        'device': device,
    }

    if cfgs['algorithm'] == 'Accous':
        cfgs['kwargs'].update({
            'dim': info['dim']
        })
        algorithm = Accous(cfgs=cfgs['kwargs'], **alg_kwargs)
    elif cfgs['algorithm'] == 'OLR':
        cfgs['kwargs'].update({
            'dim': info['dim']
        })
        algorithm = OLR(cfgs=cfgs['kwargs'], **alg_kwargs)
    elif cfgs['algorithm'] == 'ONES':
        algorithm = 'ONES'
    elif cfgs['algorithm'] == 'KMM':
        algorithm = 'KMM'
    elif cfgs['algorithm'] == 'KLIEP':
        algorithm = 'KLIEP'
    elif cfgs['algorithm'] == 'RULSIF':
        algorithm = 'RULSIF'
    elif cfgs['algorithm'] == 'ULSIF':
        algorithm = 'ULSIF'
    else:
        raise NotImplementedError

    return algorithm
