# Python implementation for "Adapting to Continuous Covariate Shift via Online Density Ratio Estimation"

This is the python implementation for the experiments in the paper "Adapting to Continuous Covariate Shift via Online Density Ratio Estimation". We will first introduce the structure and requirements of the code, followed by a brief instruction for a quick start.


## Code Structure
`main.py` is the entrance of the program. The code mainly contains the following three parts.

* **online**: Implementations of the proposed algorithms (Accous).
  * `estimator/base.py` implements the base-algorithm.
  * `estimator/meta.py` implements the meta-algorithm.
  * `estimator/accous.py` implements the Accous algorithms.
  * the subfolder *utils* contains the codes for the basic components of Accous, including the implementations of the weighted loss estimator (`risk.py`), step size, potential, restart schedule (`schedule.py`), etc.

* **dataset**: Code for datasets pre-processing.
  * `toy_data.py` is the code for the simulated experiments on datasets.
  * `table_data.py` is the code for the real-world experiments on datasets.

* **utils**: Useful tools for running the code.
  * `argparse.py` parses the configurations.
  * `multi_thread.py` is a tool multi-threaded acceleration.
  * `shift_simulate.py` is a tool to generate the simulated continuous covariate shifts.
  * `tools.py` includes other useful tools, including a timer for testing the program runtime. 


## Requirements
* matplotlib>=3.3.3
* numpy>=1.19.2
* pandas>=1.4.1
* PyYAML>=6.0
* scikit_learn>=0.23.2
* torch>=1.7.0
* tqdm>=4.62.3

## Quick Start

1. change parameters in the config.yaml
2. (optional) run offline_training.py to obtain initial model 
3. run main.py

## Reference

If you find this code useful in your research, please consider to cite the following paper:

```
@inproceedings{zhang2023accous,
  title={Adapting to Continuous Covariate Shift via Online Density Ratio Estimation},
  author={Zhang, Yu-Jie and Zhang, Zhen-Yu and Zhao, Peng and Sugiyama, Masashi},
  booktitle={Advances in Neural Information Processing Systems 36 (NeurIPS)},
  pages = {page to appear},
  year={2023}
}
```
