import logging
import os
from datetime import datetime

cwd = os.getcwd().split('/')[-1]


# import dist_utils


class MyLogger:
    def __init__(self, log_path='./log.txt'):
        with open(log_path, 'w') as wf:
            pass
        logging.basicConfig(filename=log_path, level=logging.INFO, format='%(asctime)s - %(levelname)s - %(message)s')

        self.logger = logging.getLogger(cwd)
        self.logger.setLevel(logging.INFO)

    def info(self, msg):
        # if dist_utils.can_log():
        msg = datetime.now().strftime('<%m-%d_%H:%M:%S> ') + str(msg)
        print(msg)
        self.logger.info(msg)

    def warning(self, msg):
        # if dist_utils.can_log():
        msg = datetime.now().strftime('<%m-%d_%H:%M:%S> ') + str(msg)
        print(msg)
        self.logger.warning(msg)

    def error(self, msg):
        # if dist_utils.can_log():
        msg = datetime.now().strftime('<%m-%d_%H:%M:%S> ') + str(msg)
        print(msg)
        self.logger.error(msg)


if __name__ == '__main__':
    logger = MyLogger()

