import os
import random
import time
import numpy as np
import torch as t
from Core.DataSet import DataSet_python
import OneTrainingTest

rand_seed = 1
gpu_str = 'cuda:0'

data_dir = 'DataSet/'
res_dir = 'Result/'
data_name = 'MNIST'
print(time.strftime('%Y-%m-%d %H:%M:%S', time.localtime()) + ' ' + data_name)
data_set_information = {'type': 'image', 'image_channel': 1, 'image_height': 28, 'image_width': 28}
train_data_set = DataSet_python(data_set_file=data_dir + data_name + '/' + data_name + '_train_60K.mat',
                                data_set_information=data_set_information,
                                R_class_file=data_dir + data_name + '/' + data_name + '_train_60K_R_class.mat')
train_data_set.image_0_255_to_Neg1_Pos1()
test_data_set = DataSet_python(data_set_file=data_dir + data_name + '/' + data_name + '_test_10K.mat',
                               data_set_information=data_set_information)
test_data_set.image_0_255_to_Neg1_Pos1()

print(time.strftime('%Y-%m-%d %H:%M:%S', time.localtime()) + ' rand-seed= ' + str(rand_seed))
result_dir = res_dir + data_name + '/'
exp_str = time.strftime('%Y-%m-%d=%H-%M-%S', time.localtime())
exp_str = exp_str + '+rand' + str(rand_seed) + '+M7'
os.makedirs(name=result_dir + exp_str + '/')
result_dir = result_dir + exp_str + '/'
device = t.device('cpu')
if t.cuda.is_available():
    device = t.device(gpu_str)
random.seed(a=rand_seed)
np.random.seed(seed=rand_seed)
t.manual_seed(seed=rand_seed)
t.set_default_dtype(t.float64)

fea_ext_net_type = 'M7'
fea_ext_net_structure = None
OneTrainingTest.run(result_dir=result_dir,
                    train_data_set=train_data_set, test_data_set=test_data_set,
                    fea_ext_net_type=fea_ext_net_type, fea_ext_net_structure=fea_ext_net_structure,
                    max_epoch_num=100, decay_lr_how_often=50, decay_lr_rate=0.95,
                    batch_size=2048,
                    device=device)
