# 1. Fold structure
## 1.1 /FLM-Code/Core/
The core function modules, including:

### (1) BasicModules.py
Code implementation of some basic modules, including:
some feature extraction networks, binary fuzzy relation networks, fuzziness permissible loss, regular terms, etc.

### (2) NN_FLM.py
Code implementation of Neural Network Based Fuzzy Learning Machine (NN-FLM), including:
the training and test process, select exemplars,  save predicting result, save model, etc.

### (3) DataSet.py
Code implementation of some data processing modules, including:
load data from file and generate epoch, batch, etc.

### (4) Tool.py	:
Code implementation of the other modules, including:
generate the one-hot code of the training samples, etc.

## 1.2 Demos to illustrate how NN-FLM works, 
including:
### (1) OneTrainingTest.py
Train a NN-FLM with training set samples and evaluate the performance the learned NN-FLM with test samples.
	
### (2) Demo_MNIST.py
An experiment on the MNIST data set.

### (3) Demo_Mushroom.py
An experiment on the mushroom data set.

## 1.3 /FLM-Code/DataSet/
Two data sets, including:
### (1) /mushroom/
files of mushroom data set
	
### (2) /MNIST/
files of MNIST data set
	    
## 1.4 /FLM-Code/Result/
The default root folder of result files.

## 1.5 ReadMe.md
This file.

# 2. Runtime environment and main libraries
## 2.1 OS (Operating System )
Ubuntu 18.04.5

## 2.2 IDE (Integrated Development Environment)
PyCharm 2020.1.5

## 2.3 Main libraries
Python 3.8.12, PyTorch 1.7.0, Numpy 1.21.2, hdf5storage 0.1.16, scipy 1.7.1, etc.