# Equivariant Equation Discovery

## Data preparation

* Damped Oscillator

```
# train
python -m data_utils.damped_oscillator --n_ics 50 --noise 0.2 --smoothing gp
# validation
python -m data_utils.damped_oscillator --n_ics 10 --noise 0.2 --smoothing gp --save_name val
# test
python -m data_utils.damped_oscillator --n_ics 10 --noise 0.2 --smoothing gp --save_name test
```

* Growth

```
# train
python -m data_utils.growth --n_ics 100 --noise 0.05 --smoothing gp
# validation
python -m data_utils.growth --n_ics 20 --noise 0.05 --smoothing gp --save_name val
# test
python -m data_utils.growth --n_ics 20 --noise 0.05 --smoothing gp --save_name test
```

* Lotka-Volterra System

```
# train
python -m data_utils.lotka --n_ics 200 --noise 0.99 --smoothing gp
# validation
python -m data_utils.lotka --n_ics 20 --noise 0.99 --smoothing gp --save_name val
# test
python -m data_utils.lotka --n_ics 20 --noise 0.99 --smoothing gp --save_name test
```

* Glycolytic Oscillator

```
# train
python -m data_utils.selkov --n_ics 10 --noise 0.2 --smoothing gp
# validation
python -m data_utils.selkov --n_ics 2 --noise 0.2 --smoothing gp --save_name val
# test
python -m data_utils.selkov --n_ics 2 --noise 0.2 --smoothing gp --save_name test
```

* Reaction-Diffusion: use the script from [SINDy Autoencoder](https://github.com/kpchamp/SindyAutoencoders/tree/master/rd_solver).

## Equation Discovery

### Equivariant SINDy for Linear Symmetries (Section 5.1)

* Damped Oscillator
```
# EquivSINDy-c (ours)
bash run_scripts/dosc_noise20_esindy.sh
# SINDy
bash run_scripts/dosc_noise20_sindy.sh
# Weak SINDy
bash run_scripts/dosc_noise20_wsindy.sh
# Genetic Programming w/ PySR
python main_pysr.py --config dosc/noise20_pysr.cfg
```

* Growth
```
# EquivSINDy-c (ours)
bash run_scripts/growth_noise05_esindy.sh
# SINDy
bash run_scripts/growth_noise05_sindy.sh
# Weak SINDy
bash run_scripts/growth_noise05_wsindy.sh
# Genetic Programming w/ PySR
python main_pysr.py --config growth/noise05_pysr.cfg
```

### Equivariant SINDy in Latent Space (Section 5.2)

First, place the data file `reaction_diffusion.mat` in the data directory `./data`. Then, to simultaneously discover symmetry and an equivariant equation,
```
python main.py --config rd/sym_eq.cfg
```

### Symmetry Regularization (Section 5.3)
* Lotka-Volterra System
```
# Symmetry Discovery (run this before any equivariant method)
python main.py --config lv/noise99_sym.cfg

# Sparse regression
# SINDy
bash run_scripts/lv_noise99_eq_sindy.sh
# WSINDy
bash run_scripts/lv_noise99_eq_wsindy.sh
# EquivSINDy-i (ours)
bash run_scripts/lv_noise99_eq_ireg.sh
# EquivSINDy-f (ours)
bash run_scripts/lv_noise99_eq_freg.sh
# EquivSINDy-r (ours)
bash run_scripts/lv_noise99_eq_rreg.sh

# Genetic programming
# PySR
python main_pysr.py --config lv/noise99_eq_pysr.cfg
# EquivGP-r (ours)
python main_pysr.py --config lv/noise99_eq_pysr_symm.cfg
```

* Glycolytic Oscillator (Sel'Kov)
```
# Symmetry Discovery (run this before any equivariant method)
python main.py --config selkov/noise20_sym.cfg

# Sparse regression
# SINDy
bash run_scripts/selkov_noise20_eq_sindy.sh
# WSINDy
bash run_scripts/selkov_noise20_eq_wsindy.sh
# EquivSINDy-i (ours)
bash run_scripts/selkov_noise20_eq_symreg.sh
# EquivSINDy-f (ours)
bash run_scripts/selkov_noise20_eq_symreg2.sh
# EquivSINDy-r (ours)
bash run_scripts/selkov_noise20_eq_symreg3.sh

# Genetic programming
# PySR
python main_pysr.py --config selkov/noise20_eq_pysr.cfg
# EquivGP-r (ours)
python main_pysr.py --config selkov/noise20_eq_pysr_symm.cfg
```
