import pandas as pd

def count_rows_with_keywords(file_path):
    # 读取CSV文件
    df = pd.read_csv(file_path)

    # 将所有数据转换为字符串，并检测包含"glucose"或"diabete"的行
    keyword_mask = df.apply(lambda row: row.astype(str).str.contains('glucose', case=False, na=False).any() or
                                        row.astype(str).str.contains('insulin', case=False, na=False).any() or
                                        row.astype(str).str.contains('diabete', case=False, na=False).any(), axis=1)

    # 统计满足条件的行数
    count = keyword_mask.sum()

    return count

# 使用示例
file_path = 'benchmarks/MedMCQA/test/test.csv'
count = count_rows_with_keywords(file_path)
print(f"包含'glucose'或'diabete'字样的行数: {count}")