from setuptools import setup
from torch.utils.cpp_extension import BuildExtension, CUDAExtension

setup(
    name='dspattn',
    version='0.0.1',
    description='Custom library for Dynamic Sparse Self-Attention for pytorch',
    package_dir={'':"src"},
    packages=['dspattn'],
    ext_modules=[
        CUDAExtension('dsp.softmax', 
                      ['src/cuda/softmax.cpp', 'src/cuda/softmax_kernel.cu'],
                      extra_compile_args={'cxx':[], 'nvcc':['-arch=sm_80', '-lcusparse']}),
        CUDAExtension('dsp.sddmm', 
                      ['src/cuda/sddmm.cpp', 'src/cuda/sddmm_kernel.cu'],
                      extra_compile_args={'cxx':['-lineinfo'], 'nvcc':['-arch=sm_80', '--ptxas-options=-v', '-lineinfo', '-maxrregcount=250']},
                      include_dirs=['/home/xxx/cutlass/include']),
        CUDAExtension('dsp.meta', 
                      ['src/cuda/meta.cpp', 'src/cuda/meta_kernel.cu'],
                      extra_compile_args={'cxx':['-lineinfo'], 'nvcc':['-arch=sm_80', '--ptxas-options=-v', '-lineinfo', '-lcublass']},
                      include_dirs=['/home/xxx/cutlass/include', '/home/xxxx/cutlass/tools/util/include', '/home/xxxx/cutlass/examples/common']),
        CUDAExtension('dsp.spmm', 
                      ['src/cuda/spmm.cpp', 'src/cuda/spmm_kernel.cu'],
                      extra_cuda_cflags=['-lineinfo'],
                      extra_compile_args={'cxx':['-lineinfo'], 'nvcc':['-arch=sm_80', '--ptxas-options=-v', '-lineinfo', '-lcublass']},
                      include_dirs=['/home/xxxx/cutlass/include', '/home/xxxx/cutlass/tools/util/include', '/home/xxxx/cutlass/examples/common']),
        CUDAExtension('dsp.blockspmm', 
                      ['src/cuda/block_spmm.cpp', 'src/cuda/block_spmm_kernel.cu'],
                      extra_cuda_cflags=['-lineinfo'],
                      extra_compile_args={'cxx':['-lineinfo'], 'nvcc':['-arch=sm_80', '--ptxas-options=-v', '-lineinfo', '-lcublass']},
                      include_dirs=['/home/xxxx/cutlass/include', '/home/xxxx/cutlass/tools/util/include', '/home/xxxx/cutlass/examples/common']),
        CUDAExtension('dsp.blocksddmm', 
                      ['src/cuda/block_sddmm.cpp', 'src/cuda/block_sddmm_kernel.cu'],
                      extra_compile_args={'cxx':['-lineinfo'], 'nvcc':['-arch=sm_80', '--ptxas-options=-v', '-lineinfo', '-maxrregcount=250']},
                      include_dirs=['/home/xxx/cutlass/include']),
        ],
    cmdclass={'build_ext': BuildExtension},
    install_requires=['torch']
)

