export MASTER_PORT=29510 \
MAX_PIXELS=262144 \
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 \
NPROC_PER_NODE=8 \

swift rlhf \
    --rlhf_type grpo \
    --model /dfs/data/CR/ChartVR/qwen2.5-vl-7b \
    --model_type qwen2_5_vl \
    --external_plugins /dfs/data/CR/ms-swift/examples/train/grpo/plugin/plugin.py \
    --reward_funcs external_acc_by_llm format\
    --use_vllm true \
    --train_type full \
    --freeze_vit True \
    --freeze_llm False\
    --freeze_aligner False\
    --vllm_gpu_memory_utilization 0.5 \
    --torch_dtype bfloat16 \
    --dataset /dfs/data/CR/grpo_data/grpo_train_1.jsonl \
    --split_dataset_ratio 0.05 \
    --max_completion_length 1024 \
    --seed 42 \
    --num_train_epochs 5 \
    --max_grad_norm 0.5 \
    --per_device_train_batch_size 1 \
    --per_device_eval_batch_size 1 \
    --generation_batch_size 32 \
    --learning_rate 1e-6 \
    --gradient_accumulation_steps 8\
    --eval_steps 350 \
    --save_steps 350 \
    --save_total_limit 5 \
    --logging_steps 5 \
    --output_dir /dfs/data/CR/ChartVR/grpo7b/921 \
    --warmup_ratio 0.05 \
    --dataloader_num_workers 8 \
    --dataset_num_proc 8 \
    --num_generations 4 \
    --temperature 1 \
    --async_generate false \
    --dynamic_sample true \
    --deepspeed zero3 \
    --log_completions true \
    --num_iterations 1 \
    --system /dfs/data/CR/code/train/empty.txt \
    --report_to tensorboard \