export MASTER_PORT=29510 \
WANDB_PROJECT=Chart-R1 \
MAX_PIXELS=262144 \
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 \
NPROC_PER_NODE=8 \

swift rlhf \
    --rlhf_type grpo \
    --model model/Qwen2.5-VL-3B-Instruct \
    --model_type qwen2_5_vl \
    --external_plugins ms-swift/examples/train/grpo/plugin/plugin.py \
    --reward_funcs external_acc_by_llm\
    --use_vllm true \
    --train_type full \
    --freeze_vit True \
    --freeze_llm False\
    --freeze_aligner False\
    --vllm_gpu_memory_utilization 0.6 \
    --torch_dtype bfloat16 \
    --dataset data/grpo/grpo_train_gemma.jsonl \
    --val_dataset data/grpo/val.jsonl \
    --max_completion_length 1024 \
    --seed 42 \
    --num_train_epochs 10 \
    --max_grad_norm 0.5 \
    --per_device_train_batch_size 4 \
    --per_device_eval_batch_size 4 \
    --generation_batch_size 32 \
    --learning_rate 1e-6 \
    --gradient_accumulation_steps 2\
    --eval_steps 500 \
    --save_steps 500 \
    --save_total_limit 5 \
    --logging_steps 5 \
    --output_dir qwen_rl_zero/7.30 \
    --warmup_ratio 0.05 \
    --dataloader_num_workers 8 \
    --dataset_num_proc 8 \
    --num_generations 4 \
    --temperature 1 \
    --async_generate false \
    --dynamic_sample true \
    --deepspeed zero2 \
    --log_completions true \
    --num_iterations 1 \
    --report_to wandb \
    --system ./train/empty.txt