from ray.rllib.env.wrappers.pettingzoo_env import PettingZooEnv, ParallelPettingZooEnv
import warnings
warnings.filterwarnings("ignore")
import numpy as np
import gym
from rware.warehouse import RewardType
from gymnasium.spaces import Box, Discrete

from ray.rllib.env import MultiAgentEnv
from dm_control.locomotion import soccer
from copy import deepcopy

class IndependentAdversarialEnvironment(ParallelPettingZooEnv):
    def __init__(self, env):
        super().__init__(env)
        self._agent_ids = env.agents

    def set_adversaries(self, adversaries, target):
        self.adversaries = adversaries
        self.target = target
    
    def step(self, action):
        obs, rew, done, trunc, info = super().step(action)
        for agent in rew.keys():
            if agent in self.adversaries:
                if self.target == "social-welfare":
                    welfare = deepcopy(rew)
                    for adv in self.adversaries:
                        welfare.pop(adv)
                    rew[agent] = -sum(welfare.values())
                else:
                    rew[agent] = -rew[self.target]
        return obs, rew, done, trunc, info