import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import matplotlib
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
from mpl_toolkits.axes_grid1 import make_axes_locatable
from scipy import signal
from scipy import linalg
from scipy import stats
import scipy.io as sio
import os
import shutil
from scipy.interpolate import interp1d
from scipy.stats import pearsonr
import pickle
import copy
import random
import seaborn as sns

from settings import settings
from utils import *

filters = DataContainer()

""" filter-1 """
Wn = [0.01, 0.13]
N = 3
fs = 0.75
btype = 'bandpass'
sos = signal.butter(N, Wn, fs=fs, btype=btype, output='sos')
flt = DataContainer()
flt.Wn = Wn
flt.N = N
flt.sos = sos
flt.fs = fs
flt.btype = btype
flt.description = 'band pass filters for fmri data (0.75 Hz)'
filters.flt1 = flt

""" filter-2 """
Wn = [0.01, 0.1]
N = 3
fs = 1
btype = 'bandpass'
sos = signal.butter(N, Wn, fs=fs, btype=btype, output='sos')
flt = DataContainer()
flt.Wn = Wn
flt.N = N
flt.sos = sos
flt.fs = fs
flt.btype = btype
flt.description = 'band pass filters for fmri data (1 Hz)'
filters.flt2 = flt