import os
import argparse
from utils import *


# Arguments
def parse_args():
    parser = argparse.ArgumentParser(description='Process data')
    parser.add_argument('--dataset_path', type=str, 
                        help='path to the dataset',
                        required=True)
    args = parser.parse_args()
    return args

if __name__ == '__main__':
    args = parse_args()
    print("Processing data for dataset: ", args.dataset_path, "...")
    if not os.path.exists(args.dataset_path):
        print("Dataset path does not exist!")
        exit()
    if os.path.exists(os.path.join(args.dataset_path, "train_set")):
        train_data = process_gnn_data(os.path.join(args.dataset_path, "train_set"))
        train_ic_data = process_ic_data(os.path.join(args.dataset_path, "train_set"))
    if os.path.exists(os.path.join(args.dataset_path, "val_set")):
        val_data = process_gnn_data(os.path.join(args.dataset_path, "val_set"))
        val_ic_data = process_ic_data(os.path.join(args.dataset_path, "val_set"))
    if os.path.exists(os.path.join(args.dataset_path, "test_set")):
        test_data = process_gnn_data(os.path.join(args.dataset_path, "test_set"))
        test_ic_data = process_ic_data(os.path.join(args.dataset_path, "test_set"))
    print("Data processing finished successfully!")