# DiaQ: Direction-aware Activation Quantization for Fast and Accurate Model Inference

This repository contains the code for DiaQ, submitted to ICLR 2026.
We integrate DiaQ to activation quantizers of the official implementations of [QuaRot](https://github.com/spcl/QuaRot) and [RepQ](https://github.com/zkkli/RepQ-ViT).
In addition, we provide code to evaluate the performance of DiaQ in synthetic matrix-vector multiplications.


## Contents
The `QuaRot` directory contains the implementation of QuaRot with DiaQ applied.
The `RepQ` directory contains the implementation of RepQ with DiaQ applied.
Except for the activation quantization-related code, the structures of the original repositories have been preserved.
The `main.py` file contains the code to evaluate the performance of DiaQ in synthetic matrix-vector multiplications.


## Setup
### QuaRot
Install required packages in Python 3.11 environments as follows.
```bash
cd QuaRot
pip install -r requirements.txt
pip install fast-hadamard-transform
```
CUDA 12.2 is recommended.


### RepQ
Install required packages in Python 3.9 environments as follows.
```bash
pip install --index-url https://download.pytorch.org/whl/cu116 \
  "torch==1.13.1+cu116" \
  "torchvision==0.14.1+cu116" \
  "torchaudio==0.13.1"
pip install timm==0.4.12
```


## Usage

### QuaRot
Execute `main.py` in `QuaRot` directory for experiments.
We add the following arguments to control the experimental settings for DiaQ.

- `--diaq`: (flag, default: False) Enable DiaQ for activation quantization (activated when the flag is set)
- `--alpha`: (float, default: 0.5) Extension hyperparameter for DiaQ
- `--beta`: (float, default: 1.0) Balancing hyperparameter for DiaQ
- `--save_error_path`: (str, default: None) Path to save the statistics of quantization error

The rest of arguments remains unchanged from the original code.

To run the sample script, set the path to the pre-trained model in `QuaRot/run.sh` file according to your environment
and execute the script as follows.
```bash
cd QuaRot
bash run.sh
```

### RepQ
Execute `test_quant.py` in `RepQ` directory for experiments.
We add the following arguments to control the experimental settings for DiaQ.

- `--diaq`: (flag, default: False) Enable DiaQ for activation quantization (activated when the flag is set)
- `--alpha`: (float, default: 0.5) Extension hyperparameter for DiaQ
- `--beta`: (float, default: 1.0) Balancing hyperparameter for DiaQ
- `--save_error_path`: (str, default: None) Path to save the statistics of quantization error

The rest of arguments remains unchanged from the original code.

To run the sample script, set the path to the dataset in `RepQ/run.sh` file according to your environment
and execute the script as follows.
```bash
cd RepQ
bash run.sh
```

### Synthetic matrix-vector multiplication
Execute `main.py` in the root directory for experiments.
We provide the following arguments to control the experimental settings.

- `--seed`: (int, default: 0) Random seed for initialization
- `--iter`: (int, default: 1000) Number of iterations
- `--m`: (int, default: 1024) Number of rows of the matrix
- `--n`: (int, default: 1024) Number of columns of the matrix
- `--bit`: (int, default: 4) Bit-width for quantization
- `--alpha`: (float, default: 0.5) Extension hyperparameter for DiaQ
- `--beta`: (float, default: 1.0) Balancing hyperparameter for DiaQ

To run the sample experiment, execute the following command.
```bash
python main.py --m 1024 --n 1024 --bit 4 --iter 1000 --alpha 0.5 --beta 1.0
```