GPU=0

# FILL_YOUR_PATH
path=/model/Llama-3-8B
model_name=$(basename $path)

export TOKENIZERS_PARALLELISM=false

alpha=0.5
beta=1.0

mkdir -p error/$model_name
mkdir -p log/$model_name

CUDA_VISIBLE_DEVICES=$GPU python main.py --model $path --rotate --a_bits 4 --w_bits 4 --v_bits 4 --k_bits 4 --k_groupsize 128 --v_groupsize 128 --a_asym --w_asym --w_clip \
    --lm_eval --lm_eval_batch_size 32 --tasks arc_challenge arc_easy piqa winogrande boolq \
    --diaq --alpha $alpha --beta $beta \
    --load_qmodel_path model/$model_name-gptq-4bit \
    --save_error_path error/$model_name/err-$alpha-$beta.pkl \
    2>&1 | tee  log/$model_name/log-$alpha-$beta.txt

