import argparse
import os

parser = argparse.ArgumentParser()

parser.add_argument('--logpath', type=str, default='flog', help='log file path')
parser.add_argument('--nbits', type=int, default=4, help='number of bits')
parser.add_argument('--dataset', type=str, default='imagenet', help='dataset name')

args = parser.parse_args()

logroot = f'{args.logpath}/W{args.nbits}A{args.nbits}'

models = ['vit_small', 'vit_base', 'deit_tiny', 'deit_small', 'deit_base', 'swin_tiny', 'swin_small']
for model in models:
    modelpath = f'{logroot}/{model}/{args.dataset}'

    bestacc = 0.0
    bestlog = ''

    for log in os.listdir(modelpath):
        if 'rts' not in log:
            continue

        logpath = f'{modelpath}/{log}'
        with open(logpath, 'r') as f:
            lines = f.readlines()

        line = lines[-1] #  * Prec@1 75.904 Prec@5 92.174 Time 401.765
        acc = float(line.split('Prec@1')[1].split('Prec@5')[0].strip())

        if acc > bestacc:
            bestacc = acc
            bestlog = log
            
    print(f'{model:10}: {bestacc:.02f} <- {bestlog}')


    