!/bin/bash

GPU=0

model=vit_base

# FILL_YOUR_PATH
data_path=/data/imagenet
dataname=$(basename $data_path)

nbit=4

alpha=0.5
beta=1.0

seed=0

mkdir -p err/W${nbit}A${nbit}/$model/$dataname
mkdir -p log/W${nbit}A${nbit}/$model/$dataname
CUDA_VISIBLE_DEVICES=$GPU python test_quant.py --model $model --dataset $data_path --diaq --alpha $alpha --beta $beta --w_bit $nbit --a_bit $nbit \
--save_error_path err/W${nbit}A${nbit}/$model/$dataname/err_${alpha}_${beta}.pkl \
2>&1 | tee  log/W${nbit}A${nbit}/$model/$dataname/log_${alpha}_${beta}.txt
