from collections import defaultdict
import random
from micro_config import MetaConfig
from base_configs import project_root, AdamWConfig
from gradient_descent import generate_gradient_descent_prompt_data
from incoder_config import IncoderModelConfig
from incoder_spider_data import create_spider_injection_data, load_spider
from incoder_core import IncoderInferenceConfig, IncoderTrainConfig
import contextlib
from nat_inst.ni_formatter import get_formatted_ni_data
from task_assoc import generate_task_association_data, get_binary_tasks
from injection_functions import distill, format_input, generate_distillation_data, random_token_questions, tk_generate_questions
import pickle as pkl
import jax
import json
import os
import numpy as np
from transformers import T5Tokenizer
from tk_inject import generate_tk_instance, tk_evaluate
from utils.randomness import RandomState, seed_context
import wandb

if __name__ == "__main__":
    
    # setup
    
    model_out_path = None
    data_paths = ["../../outputs/spider_long2_distill_cache_test2/", "../../outputs/spider_long2_distill_cache_test1/"]
    student_checkpoint = None

    dbs = [
        'cre_Theme_park', 
        'assets_maintenance', 
        'sakila_1', 
        'hospital_1', 
    ]

    # dbs = dbs[:(len(dbs) // 2)]

    # dbs = dbs[(len(dbs) // 2):]

    injection_datas = defaultdict(list)
    for data_path in data_paths:
        with open(os.path.join(data_path, 'raw_injection_data.pkl'), 'rb') as f:
            for k, v in pkl.load(f).items():
                injection_datas[k].extend(v)
    
    with open('../../data/spider/train_spider.json', 'r') as f:
        raw_data = json.load(f)

    rng_key = jax.random.PRNGKey(0)
    random_state = RandomState(0)

    in_length = 1024+512+(512-208)
    out_length = 208
    model_str = 'facebook/incoder-6B'

    for db in dbs:

        with seed_context(random_state):
            random.shuffle(injection_datas[db])
    
    n_injection_datas = len(injection_datas[dbs[0]])
        
    for curr_injection_idx in range(n_injection_datas):

        for db in dbs:

            general_distill_data = []
            for data_path in data_paths:
                with open(os.path.join(data_path, 'distill_data_%s.pkl' % (db)), 'rb') as f:
                    general_distill_data += pkl.load(f)
            
            injection_data = injection_datas[db][curr_injection_idx]

            data_out_path = "../../outputs/long2_distill_from_cache_test4_combined_data/%s_%d/" % (db, curr_injection_idx)
            random_state = RandomState(0)
            rng_key = jax.random.PRNGKey(0)
            # rng_key, new_key = jax.random.split(rng_key)
            # random_state = RandomState(jax.random.randint(new_key, [], 0, 2**30).item())
            
            if model_out_path is not None:
                if not os.path.exists(os.path.dirname(model_out_path)):
                    os.makedirs(os.path.dirname(model_out_path))
            if not os.path.exists(os.path.dirname(data_out_path)):
                os.makedirs(os.path.dirname(data_out_path))

            # simotaneous injection
            # distill_data = sum(distill_items[:(curr_injection_idx+1)], [])
            distill_data = [{**item, 'student_in_str': injection_data.student_prompt+item['student_in_str']} for item in general_distill_data]

            all_idx_outputs = defaultdict(list)

            print('loading student ...')

            metaconfig = MetaConfig(
                project_root=project_root, 
                verbose=False, 
            )

            model_config = IncoderModelConfig(
                # model_str="google/t5-v1_1-xl", 
                # model_str="t5-3b", 
                # model_str="google/ul2", 
                model_str=model_str, 
                # model_str="allenai/tk-instruct-11b-def-pos-neg-expl", 
                checkpoint_path=student_checkpoint, 
                from_pretrained=True, 
                use_fp16=True, 
                gradient_checkpoint=True, 
            )
            
            trainer_config = IncoderTrainConfig(
                model=model_config, 
                optim=AdamWConfig(
                    grad_accum_steps=4, 
                    lr=1e-4, 
                    weight_decay=0.00, 
                    beta1=0.9, 
                    beta2=0.999, 
                    eps=1e-6, 
                ), 
                pjit=True, 
                verbose=True, 
            )

            trainer, inference, model, mesh = trainer_config.unroll(metaconfig)

            _, _, tokenizer, _ = model_config.unroll(metaconfig)


            print('evaluating student before distillation ...')

            pre_distill_model_accuracies = {}
            
            print('db:', db)
            rng_key, new_rng = jax.random.split(rng_key)
            acc, all_results = tk_evaluate(injection_data, teacher_eval=False, 
                                            inference=inference, mesh=mesh, bsize=1, num_instances=None, 
                                            max_input_length=in_length, rng_key=new_rng, 
                                            do_sample=False, num_beams=1, max_length=in_length+out_length, 
                                            pad_token_id=tokenizer.pad_token_id, 
                                            eos_token_id=tokenizer.encode('\n\n')[0])
            pre_distill_model_accuracies[db] = {'acc': acc, 'all_results': all_results}
            print('accuracy:', acc)
            
            with open(os.path.join(data_out_path, 'pre_distill_student_accuracies.pkl'), 'wb') as f:
                pkl.dump(pre_distill_model_accuracies, f)
            
            for z, (q, refs) in enumerate(injection_data.dataset_eval):
                ref = refs[0]
                for idx, item2 in enumerate(raw_data):
                    if q.strip() == item2['question'] and ref == item2['query']:
                        all_idx_outputs[f'raw_student_{curr_injection_idx}'].append((idx, all_results[z]['generation'].strip()))
                        break
            
            with open(os.path.join(data_out_path, 'all_idx_outputs.pkl'), 'wb') as f:
                pkl.dump(all_idx_outputs, f)
            
            # distill student
        
            if jax.process_index() == 0:
                wandb_state = wandb.init(project="distill_spider", name="%s_%d" % (db, curr_injection_idx), reinit=True)
            
            for epoch in range(4):
                
                print('distilling ...')
                
                rng_key, new_rng = jax.random.split(rng_key)
                trainer = distill(distill_data, trainer, mesh, bsize=4, epochs=1, max_input_length=in_length, rng_key=new_rng, decompress_smoothing_epsilon=1e-7)

                inference.update_params(trainer.params)

                # eval student

                print('evaluating student after distillation ...')

                post_distill_student_accuracies = {}
                
                print('db:', db)
                rng_key, new_rng = jax.random.split(rng_key)
                acc, all_results = tk_evaluate(injection_data, teacher_eval=False, 
                                            inference=inference, mesh=mesh, bsize=1, num_instances=None, 
                                            max_input_length=in_length, rng_key=new_rng, 
                                            do_sample=False, num_beams=1, max_length=in_length+out_length, 
                                            pad_token_id=tokenizer.pad_token_id, 
                                            eos_token_id=tokenizer.encode('\n\n')[0])
                post_distill_student_accuracies[db] = {'acc': acc, 'all_results': all_results}
                print(acc)
                if jax.process_index() == 0:
                    wandb.log(acc)
                
                with open(os.path.join(data_out_path, f'post_distill_student_accuracies_epoch_{epoch}.pkl'), 'wb') as f:
                    pkl.dump(post_distill_student_accuracies, f)
                
                for z, (q, refs) in enumerate(injection_data.dataset_eval):
                    ref = refs[0]
                    for idx, item2 in enumerate(raw_data):
                        if q.strip() == item2['question'] and ref == item2['query']:
                            all_idx_outputs[f'post_distill_student_{curr_injection_idx}_epoch_{epoch}'].append((idx, all_results[z]['generation'].strip()))
                            break
            
            if jax.process_index() == 0:
                wandb.finish()
            
            with open(os.path.join(data_out_path, 'all_idx_outputs.pkl'), 'wb') as f:
                pkl.dump(all_idx_outputs, f)
            
            print('summary:')
            print('pre-distill accuracy:', pre_distill_model_accuracies[db]['acc'])
            print('post-distill accuracy:', post_distill_student_accuracies[db]['acc'])

            del trainer
            del inference
            del model
            del mesh
            trainer, inference, model, mesh, = None, None, None, None
