import json
import random


def read_jsonl(data_path: str) -> list:
    datas = []
    with open(data_path, 'r') as f:
        for line in f:
            datas.append(json.loads(line))
    return datas


def write_jsonl(data_path: str, datas: list) -> None:
    with open(data_path, 'w') as f:
        for data in datas:
            json.dump(data, f)
            f.write('\n')


def random_sample(data_path: str,  dev_path: str, test_path: str, dev_num: int, test_num: int):
    print(f"The data_path is {data_path}, dev_path is {dev_path}, test_path is {test_path}")
    print(f"The dev_num is {dev_num}, test_num is {test_num}")
    datas = read_jsonl(data_path)
    dev_datas = random.sample(datas, dev_num)
    print(f"The dev_datas len is {len(dev_datas)}")
    datas = list(filter(lambda x: x not in dev_datas, datas))
    print(f"The datas len is {len(datas)}")
    test_datas = random.sample(datas, test_num)
    print(f"The test_datas len is {len(test_datas)}")
    datas = list(filter(lambda x: x not in test_datas, datas))
    print(f"The datas len is {len(datas)}")
    write_jsonl(data_path, datas)
    write_jsonl(dev_path, dev_datas)
    write_jsonl(test_path, test_datas)
