"""
Supports OpenAI-type communication interfaces.
"""
import json
import requests


class OpenAIClient(object):

    def __init__(self, attrs):
        self.attrs = attrs
        self.retry = 5
        self.timeout = 3600

    def _check_pre(self, query: list):
        messages = [
                {
                    "role": "system",
                    "content": " \n\n"
                }
            ]
        messages.extend(query)
        json_data = {
            "model": self.attrs["model"],
            "messages": messages,
            "temperature": 1,
            "max_tokens": 4096
        }

        return json_data

    def chat(self, query):
        json_data = self._check_pre(query)
        json_data["stream"] = False
        response = requests.post(url=self.attrs["url"], json=json_data, timeout=self.timeout)
        # print(f"response: {response.json()}")
        return response.json()['choices'][0]['message'].get('content', '')

    def chat_and_check(self, query, check_func):
        check_status = False
        reason, result = "", {}
        retry = self.retry
        while not check_status and retry > 0:
            response = self.chat(query)
            check_status, reason, result = check_func(response)
            retry -= 1
        if not check_status:
            raise ValueError("Can`t successfully retrieve the correct response!")
        return reason, result
