# Rethinking LLM Parametric Knowledge as Confidence for Effective and Efficient RAG
[English](readme.md) | [简体中文](readme_zh-CN.md)

## 声明

代码中包含了以下内容：

-  Confidence Detection Model 的相关代码，包括模型结构、训练数据集构建、训练代码。

- NQ_Rerank 数据集构建代码

- Reranker 模型的微调代码、评测代码

- RAG 系统的评测代码，包括根据置信度动态检索的代码

- 相关模型权重以及相关数据集我们将在论文发表后公开

## 置信度探测模型

Confidence Detection Model 的训练完全遵循了论文  *Towards Fully Exploiting LLM Internal States to Enhance Knowledge Boundary Perception (https://arxiv.org/abs/2502.11677)*  的流程，并且代码也使用了他们开源的相关代码（代码原址：https://github.com/Trustworthy-Information-Access/LLM-Knowledge-Boundary-Perception-via-Internal-States）。我们仅做了少量的改动，因此在这里做相关声明。

### Hidden Detection Model 模型结构

见 hidden_state_detection/models.py 中的 MLPNet；文章中采用的是 MLPNet。

### 获取目标LLM的内部隐藏状态

```bash
python -u run_nq.py \
 --source ./data/nq/nq-dev.jsonl \
 --type qa \
 --ra none \
 --outfile ./data/nq/nq-dev-res.jsonl \
 --model_path YOUR_MODEL_PATH \
 --batch_size 36 \
 --task nq \
 --max_new_tokens 512 \
 --hidden_states 1 \
 --hidden_idx_mode first \
 --need_layers mid
```

- 其中 model_path 填写目标 LLM 的权重

### 训练代码

见 hidden_state_detection/main.py；您可以直接通过 bash hidden_state_detection/scripts/run_nq.sh  执行训练。

## NQ_Rerank 数据集构建

### 模型相关代码

#### 与 LLM 通信

你需要运行你的 LLM，并使其支持 openai 形式的接口。你可以通过以下方式调用：

```python
from llms import OpenAIClient

llm_client = OpenAIClient({
    "model": "qwen",            # model name
    "url": "http://127.0.0.1:8081/v1/chat/completions",    # url
})

message = [{"role": "user", "content": "Hello"}]

response = llm_client.chat(message)
```

#### 构建 NQ_Rerank 数据集

见 wash_rerank_data.py 中的 generate_rerank_preference_dataset 函数，你需要首先获取 NQ 部分数据集中每个 Context 的置信度分数

## Reranker 模型

#### 加载 Reranker model

你需要提前下载对应的 Reranker 权重。你可以通过以下方式调用：

```python
from llms import BgeRerankCls, GteRerankCls, QwenRerankCls

bge_rerank_client = BgeRerankCls("weights")
gte_rerank_client = GteRerankCls("weights")
qwen_rerank_client = QwenRerankCls("weights")

eval_dataset = [{"query": "xx", "pos": [], "neg": []}, {"query": "xx", "pos": [], "neg": []}]

generate_result = bge_rerank_client.generate(eval_dataset, top_k = 1/3/5)
```

#### Reranker 训练

见 run_reranker_finetune.sh，你可以直接通过 bash run_reranker_finetune.sh 调用该训练代码。

#### Reranker 评测

见 evaluate_rerank.py，你可以通过以下命令执行：

```bash
python evaluate_rerank.py \
    --llm_weight xxx/xxx \
    --eval_data_path xxx/xxx \
    --output_data_dir xxx/xxx \
    --reranker_cls xxx/xxx \
    --top_k 1/3/5 \
```

- llm_weight: Reranker 的权重文件
- eval_data_path: 评测数据文件路径
- output_data_dir: 评测结果输出目录，将会输出两个文件；一个结果、一个中间rerank结果。
- reranker_cls: Reranker 的类别，支持：BgeRerankCls、QwenRerankCls、GteRerankCls
- top_k: 取 Reranker 重排后的 Top k 个context

## RAG 系统的评测

### 评测 RAG 系统的准确率

见 eval_rerank_and_llms.py，你可以通过以下命令执行：

```bash
python evaluate_rerank.py \
    --llm_weight xxx/xxx \
    --input_data_path xxx/xxx \
    --output_data_path xxx/xxx \
    --eval_data_path xxx/xxx \
    --reranker_cls xxx \
    --top_k 1/3/5 \
    --data_type xxx \
    --gold_data_path xxx \
    --dynamic 0/1 \
    --threshold 0.98 \
```

- llm_weight: Reranker 的权重文件
- input_data_path: 评测数据文件路径
- output_data_path: Reranker 重排结果输出路径，即 Reranker 输出重排后的 Top-k
- eval_data_path：RAG 系统执行后的结果输出路径，最终结果评测也是基于该输出
- reranker_cls: Reranker 的类别，支持：BgeRerankCls、QwenRerankCls、GteRerankCls
- top_k: 取 Reranker 重排后的 Top k 个context
- data_type：评测的数据集格式，当前支持2类：nq，hotpot_qa
- gold_data_path: 可选，当data_type = hotpot_qa 时，需要输入；详见代码
- dynamic: 可选，是否开启 CBDR 动态检索。0 标识关闭，1标识开启。默认为0
- threshold: 模型置信度阈值，开启 CBDR 后需要提供

## 暂未公开

我们将在论文发表后公布以下内容：

- Confidence Detection Model 的权重
- 偏好数据集 NQ_Rerank
- 微调后的 bge-reranker-v2-m3-ft 模型的权重
