#!/bin/bash
torchrun --nproc_per_node=8 \
-m FlagEmbedding.finetune.reranker.encoder_only.base \
--output_dir /home/xygxzs28/llms/bge_rerank_v2_m3_nq_ft_v3 \
--model_name_or_path /home/xygxzs28/llms/bge_rerank_v2_m3 \
--train_data /home/xygxzs28/knowledge_boundary/LKBP/data/nq_rerank/nq_rerank_train_filter.jsonl \
--learning_rate 6e-5 \
--fp16 \
--num_train_epochs 15 \
--per_device_train_batch_size 8 \
--gradient_accumulation_steps 4 \
--dataloader_drop_last True \
--train_group_size 7 \
--query_max_len 128 \
--passage_max_len 512 \
--weight_decay 0.01 \
--logging_steps 100 \
--save_steps 30

# explanations of arguments
# train_group_size: number of positive and negative samples
# resume_from_checkpoint: path to the checkpoint to resume from
# save_strategy: no, steps, or epoch