import json


def read_json(path):
    qa_data = []
    f = open(path, 'r', encoding='utf-8')
    for line in f.readlines():
        qa_data.append(json.loads(line))
    return qa_data


prompt_dict = {
    # 'qa': {
    #     'none': 'You need to read the question carefully and answer it based on your own knowledge. Answer the following question based on your internal knowledge with one or few words.\nQuestion: {question}{paras}{prediction}',
    #     'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words.\nQuestion: {question}{prediction}',
    #     'tail': '\nAnswer: ',
    # },

    'qa': {
        'none': 'You need to read the question carefully and answer it based on your own knowledge.\nQuestion: {question}{paras}{prediction}',
        'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words.\nQuestion: {question}{prediction}',
        'tail': '\nAnswer: ',
    },
    'qa_rag': {
        'none': 'You are a rigorous language model. Please answer the question based on the provided context. If the context does not support reasoning about the answer, please answer the question based on your own knowledge. \n Context: [] \nQuestion: {question}{paras}{prediction}',
        'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words.\nQuestion: {question}{prediction}',
        'tail': '\nAnswer: ',
    },
    'qa_cot': {
        'none': 'Answer the question by briefly explaining your reasoning with one or few sentences, then provide the final answer.\nQuestion: {question}{paras}{prediction}',
        'ra': '',
        'tail': '\nAnswer: ',
    },
    'qa_more': {
        'none': 'Generate 10 possible answers for the following question, each separated by a semicolon. These 10 answers must be different, and your response should be as concise as possible, with no irrelevant words beyond the answers.\nQuestion: {question}{paras}{prediction}',
        'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words.\nQuestion: {question}{prediction}',
        'tail': '\nAnswer: ',
    }, 
    'qa_extract': {
        'none': 'Here is the response generated by the model for this question. The response includes reasoning steps, making it difficult to locate the answer. Please extract the answer from the response without generating any other unrelated words. Do not generate conversational words.\nQuestion: {question}\nResponse: {prediction}',
        'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words.\nQuestion: {question}{prediction}',
        'tail': '\nYour extracted answer: ',
    }, 
    'qa_prior': {
        'none': 'Please determine if you can accurately provide the answer to the question. If yes, reply with "certain", otherwise reply with "uncertain". Start your response with "certain" or "uncertain" and do not give any other words.\nQuestion: {question}{paras}{prediction}',
        'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words.\nQuestion: {question}{prediction}',
        'tail': '\nResponse: ',
    }, 
    'qa_post': {
        'none': 'Here is a question and the answer you provided. Please determine whether the answer is correct. If it is correct, respond with "certain." If it is incorrect, respond with "uncertain." Start your response with "certain" or "uncertain" and do not give any other words.\nQuestion: {question}{paras}{prediction}\nResponse: {prediction}',
        'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words.\nQuestion: {question}{prediction}',
        'tail': '\nResponse: ',
    }, 
    'mc_qa': {
        'none': 'The following are multiple choice questions (with answers){subject}. Select the correct answer without any irrelevant words. Do not include conversational words and do not provide any explanation.\n\n{question}{paras}{prediction}',
        'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words.\nQuestion: {question}{prediction}',
        'tail': '\nAnswer: ',
    },
    'mc_qa_prior': {
        'none': 'Please determine if you can accurately select the correct answer to the question. If yes, reply with "certain", otherwise reply with "uncertain". Start your response with "certain" or "uncertain" and do not give any other words.\n\n{question}{paras}{prediction}',
        'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words.\nQuestion: {question}{prediction}',
        'tail': '\nResponse: ',
    }, 
    'mc_qa_post': {
        'none': 'Here is a question and the answer you select. Please determine whether the answer is correct. If it is correct, respond with "certain." If it is incorrect, respond with "uncertain." Start your response with "certain" or "uncertain" and do not give any other words.\nQuestion: {question}{paras}{prediction}\nResponse: {prediction}',
        'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words.\nQuestion: {question}{prediction}',
        'tail': '\nResponse: ',
    }, 
    'mc_qa_cot': {
        'none': 'The following are multiple choice questions (with answers){subject}. Briefly explain your reasoning with one or few sentences and choose the correct answer. Start with “So, the correct answer is” to select the correct answer.\n\n{question}{paras}{prediction}',
        'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words.\nQuestion: {question}{prediction}',
        'tail': '\nAnswer: ',
    },
    'mc_qa_evidence': {
        'none': 'The following are multiple choice questions (with answers){subject}. Select the correct answer without any irrelevant words and explain why you choose this answer briefly.\n\n{question}{paras}{prediction}',
        'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words.\nQuestion: {question}{prediction}',
        'tail': '\nAnswer: ',
    },
    'qa_evidence': {
        'none': 'Answer the following question based on your internal knowledge with one or few words and explain why you give this answer briefly.\nQuestion: {question}{paras}{prediction}',
        'ra': 'Given the following information: \n{paras}\nAnswer the following question based on the given information or your internal knowledge with one or few words and explain why you give this answer.\nQuestion: {question}{prediction}',
        'tail': '\nAnswer: ',
    },
}

model_template_dict = {
    'llama2-7b-chat':{
        'prefix': '<s>[INST] <<SYS>>\nYou are a helpful assistant<</SYS>>',
        'end': '[/INST]'
    },
    'llama3-8b-instruct':{
        'prefix': '<|begin_of_text|><|start_header_id|>system<|end_header_id|>\n\nYou are a helpful AI assistant for answering factual questions<|eot_id|><|start_header_id|>user<|end_header_id|>\n\n',
        'end': "<|eot_id|><|start_header_id|>assistant<|end_header_id|>\n\n"
    },
    'qwen2-7b-instruct':{
        'prefix': '<|im_start|>system\nYou are a helpful assistant.<|im_end|>\n<|im_start|>user\n',
        'end': '<|im_end|>\n<|im_start|>assistant'
    },
    'llama2-13b-chat':{
        'prefix': '<s>[INST] <<SYS>>\nYou are a helpful assistant<</SYS>>\n\n',
        'end': '[/INST]'
    },
}

model_template_dict_for_multi_round = {
    'llama3-8b-instruct':{
        'sys_prefix': '<|begin_of_text|><|start_header_id|>system<|end_header_id|>\n\nYou are a helpful AI assistant for answering factual questions',
        'user_prefix': '<|start_header_id|>user<|end_header_id|>\n\n',
        'assis_prefix': '<|start_header_id|>assistant<|end_header_id|>\n\n',
        'end': "<|eot_id|>\n"
    },
    'qwen2-7b-instruct':{
        'sys_prefix': '<|im_start|>system\nYou are a helpful assistant.',
        'user_prefix': '<|im_start|>user\n',
        'assis_prefix': '<|im_start|>assistant\n',
        'end': "<|im_end|>\n"
    },
}
def get_prompt(sample, args):
    paras = ""
    ref_key = 'question'
    prompt = prompt_dict[args.type]['none'] # prior
    if args.ra != 'none':
        ra_dict = args.ra
        i = 0
        doc = []
        for k, v in ra_dict.items():
            v = min(v, len(sample[k]))
            for j in range(v):
                doc.append(("Passage-%d" % i) + sample[k][j])
                i += 1
        paras = '\n'.join(doc)
        prompt = prompt_dict[args.type]['ra']
    tail = prompt_dict[args.type]['tail'] if not args.usechat else ""
    prediction = sample['Res'] if 'post' in args.type else ""
    # mmlu基础模板里带subject
    # print(args.task)
    if args.task == 'mmlu' or args.task == 'tq':
        prompt = prompt.format(question=sample[ref_key], paras=paras, prediction=prediction, subject=args.subject) + tail
    else:
        prompt = prompt.format(question=sample[ref_key], paras=paras, prediction=prediction) + tail
    # 每个模型特有的prompt格式
    template_prompt = model_template_dict[args.model_name]
    prompt = template_prompt['prefix'] + prompt + template_prompt['end']
    return prompt

def get_prompt_for_multi_round(sample, args):
    # question, answer, generate, 10answers
    """
    两轮(post):
        - factual question
        - response
        - determine right
    三轮(post_multi_round):
        - factual question
        - response
        - generate 10 answers
        - 10 answers
        - determine right
    """
    prompt = ''
    template_prompt = model_template_dict_for_multi_round[args.model_name]
    # sys
    prompt += template_prompt['sys_prefix']
    prompt += template_prompt['end']
    if args.type == 'qa_post':
        sample['question'] = sample['question'][:2] # qa_post_multi_round需要4个元素, qa_post只需要两个元素
    for idx in range(len(sample['question'])):
        if idx % 2 == 0:
            # question
            prompt += template_prompt['user_prefix']
            prompt += sample['question'][idx]
            prompt += template_prompt['end']
        else:
            # answer
            prompt += template_prompt['assis_prefix']
            prompt += sample['question'][idx]
            prompt += template_prompt['end']
   
    prompt += template_prompt['user_prefix']
    prompt += f'Please determine whether your response [{sample["question"][1]}] contains the correct answer. If yes, respond with "certain." If it is incorrect, respond with "uncertain." Start your response with "certain" or "uncertain" and do not give any other words.'
    prompt += template_prompt['end']
    prompt += template_prompt['assis_prefix']
    # print(prompt)
    return prompt

if __name__ == '__main__':
    model_name='qwen7b'
    base_dir = 'E:\\xidian\\论文\\NLP论文学习\\论文\\知识边界\\LLM-Knowledge-Boundary-Perception-via-Internal-States-master\\data\\nq\\nq-dev-test.jsonl'
    mode = 'test'
    dataset = 'nq'
    out_path = f'{base_dir}/{dataset}/multi_round/{dataset}_{mode}_{model_name}.jsonl'
    data = read_json(base_dir)
    # get_prompt(data[0], {'model_name': 'llama3-8b-instruct', 'type': 'qa'})
