from openai import OpenAI
import time
import random
import json

client = OpenAI(api_key="Your OpenAI API")

#Manage Assistants******************************************************************************************
def collect_assistant_info(num_assistants):
    """
    Collect and return a list of Assistant information defined by the user.
    Parameters:

    num_assistants: The number of Assistants the user wishes to create.
    Return:
    A list containing the information of each Assistant, each piece of information as a dictionary.
    """
    assistants_info = []

    for i in range(num_assistants):
        print(f"Enter details for assistant #{i + 1}:")
        name = input("Name: ")
        instructions = input("Instructions: ")
        model = 'gpt-3.5-turbo'
        assistants_info.append({
            "name": name,
            "instructions": instructions,
            "model": model
        })

    return assistants_info

def create_assistants(client, assistants_info):
    """
    Create multiple Assistants based on the provided information.
    Parameters:

    client: The client instance used for interacting with the API.
    assistants_info: A list containing the information for each Assistant, each piece of information as a dictionary.
    Return:
    A list of the created Assistant instances.
    """
    created_assistants = []
    for info in assistants_info:
        try:
            assistant = client.beta.assistants.create(
                name=info['name'],
                instructions=info['instructions'],
                model=info['model']
            )
            print(f"Assistant '{info['name']}' created successfully.")
            created_assistants.append(assistant)
        except Exception as e:
            print(f"An error occurred while creating the assistant '{info['name']}': {e}")

    return created_assistants

#Manage threads***************************************************************************************
def create_threads(client, num_threads):
    """
    Create multiple threads based on the user-specified quantity.
    Parameters:
    - client: The client instance used for interacting with the API.
    - num_threads: The number of threads the user wishes to create.
    Return:
    - A list containing the thread objects.
    """
    threads_list = []
    for i in range(num_threads):
        try:
            thread = client.beta.threads.create()
            threads_list.append(thread)
            print(f"Thread #{i + 1} created successfully.")
        except Exception as e:
            print(f"An error occurred while creating thread #{i + 1}: {e}")

    return threads_list



#Single Agent Structure***********************************************************************************
#Single-Human-Single-Agent
def OHOA_QA(Q_num: int, Question: list[str],
            QA_threadlist=[],tindex = 0, QA_Agentlist=[], aindex = 0, j_t = 'w',hum_put = False):
    """
    :param Q_num: Total Number of Questions that human want’s to ask
    :param Question: Content of Questions
    :param QA_threadlist: thread list
    :param tindex: thread index in QA_threadlist
    :param QA_Agentlist: Agent list
    :param aindex: Agent index in QA_Agentlist
    :param j_t: 'w' or 'a' in json
    :param hum_put: human input for Question or fixed
    """
    message_data = []

    if QA_threadlist == []:
        QA_threadlist = create_threads(client, 1)
        QA_thread = QA_threadlist[tindex]

    if QA_Agentlist == []:
        QA_Agentlist = create_assistants(client,collect_assistant_info(1))
        QA_Object = QA_Agentlist[aindex]

    for i in range(Q_num):
        if hum_put == True:
            Question[i] = input("User input:")

        #**Human**
        Usermessage = client.beta.threads.messages.create(
        thread_id= QA_thread.id,
        role="user", content= Question[i]
        )

        messages = client.beta.threads.messages.list(
            thread_id=QA_thread.id
        )

        role = "User"
        content = messages.data[0].content[0].text.value
        message_dict = {'Position': i, 'role': role, 'content': content}

        # Append message_dict to message_data list
        message_data.append(message_dict)
        print("In system Q&A {}| {}:{}".format(message_dict['Position'],
                                               message_dict["role"],message_dict["content"]))

        # **Agent**
        run = client.beta.threads.runs.create(
        thread_id=QA_thread.id,
        assistant_id=QA_Object.id
        )

        #display assistant response
        run = client.beta.threads.runs.retrieve(
            thread_id=QA_thread.id,
            run_id=run.id
        )

        #wait for run complete
        time.sleep(3)

        messages = client.beta.threads.messages.list(
            thread_id=QA_thread.id
        )

        role = "Agent"
        name = QA_Object.name
        content = messages.data[0].content[0].text.value
        message_dict = {'Q&A_index': i, 'role': role, 'name':name, 'content': content}
        message_data.append(message_dict)
        print("In system Q&A {}| {} {}:{}".format(message_dict['Q&A_index'], message_dict["role"],
                                                  message_dict["name"],message_dict["content"]))

    # Save data--------------------------------------------------------------------
    with open('messages_OHOA.json', j_t) as file:
        json.dump(message_data, file)

    return messages.data


#Multi-Human-Single-Agent (Broadcast)
def MHOA_COM(Round: int,Human_num: int, Hum_con: list[[str]],fix: list[[int]],
             COM_threadlist=[], tindex = 0, COM_Agentlist=[], aindex = 0,j_t = 'w',Hum_put = False):

    message_data = []
    Total_num = Human_num + 1
    if COM_threadlist == []:
        COM_threadlist = create_threads(client, 1)
        COM_thread = COM_threadlist[tindex]

    if COM_Agentlist == []:
        COM_Agentlist = create_assistants(client,collect_assistant_info(1))
        COM_Object = COM_Agentlist[aindex]

    for n in range(Round):
        print("BEGIN Round {} ----------------------------------------------------------".format(n))
        Order = []
        for i in range(Human_num):
            Order.append(["H", i, Hum_con[n][i]])
        Order.append(["A", Human_num, COM_Object])

        if fix[n] == []:
            Participate = random.sample(range(0, Total_num), Total_num)
        else:
            Participate = fix[n]

        New_order = []
        for k in range(Total_num):
            New_order.append(Order[Participate[k]])

        print(New_order)

        for m in range(Total_num):
            if New_order[m][0] == "H":
                # If there is real-time input, then update New_order[m][1].
                if Hum_put == True:
                    New_order[m][2] = input("User input in round {} position {}:".format(n, m))

                Usermessage = client.beta.threads.messages.create(
                    thread_id=COM_thread.id,
                    role="user", content=New_order[m][2]
                )

                messages = client.beta.threads.messages.list(
                    thread_id=COM_thread.id
                )

                role = "User"
                content = messages.data[0].content[0].text.value
                message_dict = {'round': n, 'Position': m, 'role': role, 'content': content}
                message_data.append(message_dict)
                print("In system {}| {}:{}".format(message_dict['Position'], message_dict["role"],
                                                         message_dict["content"]))

            if New_order[m][0] == "A":
                run = client.beta.threads.runs.create(
                    thread_id=COM_thread.id,
                    assistant_id=New_order[m][2].id
                )

                run = client.beta.threads.runs.retrieve(
                    thread_id=COM_thread.id,
                    run_id=run.id
                )

                time.sleep(3)

                messages = client.beta.threads.messages.list(
                    thread_id=COM_thread.id
                )

                role = "Agent"
                name = New_order[m][2].name
                content = messages.data[0].content[0].text.value
                message_dict = {'round': n, 'Position': m, 'role': role,
                                'name': name, 'content': content}
                message_data.append(message_dict)
                print("In system {}| {} {}:{}".format(message_dict['Position'], message_dict["role"],
                                                     message_dict['name'], message_dict["content"]))
        print("END Round {} ----------------------------------------------------------".format(n))
    # Save data --------------------------------------------------------------------
    with open('messages_MHOA.json', j_t) as file:
        json.dump(message_data, file)

    return messages.data


#Multi-Agent Structure***********************************************************************************
#Multi-Agent (Point-to-Pont)
def MA_COMP(Round: int,Agent_num: int, Initial_instruct: list[str],fix: list[[int]],
             MAP_threadlist=[],  MAP_Agentlist=[],j_t = 'w'):
    """
    :param Agent_num: The number of participating agents.
    :param Initial_instruct: The first instruction of each round: stores the content of human communication for one round.
    :param fix: Which agent answers, if fix = 0 then it is random.
    """
    message_data = []

    if MAP_Agentlist == []:
        MAP_Agentlist = create_assistants(client,collect_assistant_info(Agent_num))
        MAP_Object = MAP_Agentlist

    for n in range(Round):
        print("BEGIN Round {} ----------------------------------------------------------".format(n))
        MAP_threadlist = create_threads(client, Agent_num)
        MAP_thread = MAP_threadlist

        if fix[n] == []:
            Participate = random.sample(range(0, Agent_num), Agent_num)
        else:
            Participate = fix[n]


        for m in range(Agent_num):


            Usermessage = client.beta.threads.messages.create(
                thread_id=MAP_thread[m].id,
                role="user", content=Initial_instruct[n])

            messages = client.beta.threads.messages.list(
                thread_id=MAP_thread[m].id
            )

            role = "Input"
            content = messages.data[0].content[0].text.value
            message_dict = {'round': n, 'Thread': m, 'role': role, 'content': content}
            message_data.append(message_dict)
            print("In system {}| {}:{}".format(message_dict['Thread'], message_dict["role"],
                                               message_dict["content"]))


            run = client.beta.threads.runs.create(
            thread_id=MAP_thread[m].id,
            assistant_id=MAP_Object[Participate[m]].id
            )

            run = client.beta.threads.runs.retrieve(
                thread_id=MAP_thread[m].id,
                run_id=run.id
            )

            time.sleep(2)

            messages = client.beta.threads.messages.list(
                thread_id=MAP_thread[m].id
            )

            role = "Agent"
            name = MAP_Object[Participate[m]].name
            content = messages.data[0].content[0].text.value
            message_dict = {'round':n, 'Thread': m, 'role': role, 'name': name, 'content': content}
            message_data.append(message_dict)
            print("In system {}| {} {}:{}".format(message_dict['Thread'], message_dict["role"],
                                               message_dict["name"], message_dict["content"]))

            # Renew information
            Initial_instruct[n] = messages.data[0].content[0].text.value

        print("END Round {} ----------------------------------------------------------".format(n))


    # Save data --------------------------------------------------------------------
    with open('messages_MAP.json', j_t) as file:
        json.dump(message_data, file)
    #-----------------------------------------------------------------------------------------------------------------------
    return messages.data

#Multi-Agent (Broadcast)
def MA_COM(Round: int,Agent_num: int, Initial_instruct: list[str],fix: list[[int]],
           MA_threadlist=[], tindex = 0, MA_Agentlist=[],j_t = 'w',hum_put = False):

    message_data = []

    if MA_threadlist == []:
        MA_threadlist = create_threads(client, 1)
        MA_thread = MA_threadlist[tindex]

    if MA_Agentlist == []:
        MA_Agentlist = create_assistants(client,collect_assistant_info(Agent_num))
        MA_Object = MA_Agentlist

    for n in range(Round):
        print("BEGIN Round {} ----------------------------------------------------------".format(n))
        if hum_put == True:
            Initial_instruct[n]=input("Initial instruction user input: ")
        Usermessage = client.beta.threads.messages.create(
            thread_id=MA_thread.id,
            role="user", content=Initial_instruct[n])

        messages = client.beta.threads.messages.list(
            thread_id=MA_thread.id
        )

        role = "Initial instruction"
        content = messages.data[0].content[0].text.value
        message_dict = {'round': n, 'role': role, 'content': content}
        message_data.append(message_dict)
        print("In system| {}:{}".format( message_dict["role"],
                                           message_dict["content"]))

        if fix[n] == []:
            Participate = random.sample(range(0, Agent_num), Agent_num)
        else:
            Participate = fix[n]


        for m in range(Agent_num):

            run = client.beta.threads.runs.create(
            thread_id=MA_thread.id,
            assistant_id=MA_Object[Participate[m]].id
            )

            run = client.beta.threads.runs.retrieve(
                thread_id=MA_thread.id,
                run_id=run.id
            )

            time.sleep(2)

            messages = client.beta.threads.messages.list(
                thread_id=MA_thread.id
            )

            role = "Agent"
            name = MA_Object[Participate[m]].name
            content = messages.data[0].content[0].text.value
            message_dict = {'round':n, 'Position': m, 'role': role, 'name': name, 'content': content}
            message_data.append(message_dict)
            print("In system {}| {} {}:{}".format(message_dict['Position'], message_dict["role"],message_dict["name"], message_dict["content"]))

        print("END Round {} ----------------------------------------------------------".format(n))
    # Safe data------------------------------------------------------------------------
    with open('messages_MA.json', j_t) as file:
        json.dump(message_data, file)

    return messages.data


#MultiHuman-MultiAgent Structure*********************************************************************************
#Multi-Human-Multi-Agent Broadcast, real-time input from Human
def MHMA_COM(Round: int, Human_num:int, Hum_con:[[str]],Agent_num: int,fix = [[int]],
             MHMA_threadlist=[], tindex = 0, MHMA_Agentlist=[],j_t = 'w', Hum_put = True):
    """
    :param Round: Total Communication Round
    :param Human_num: The number of Human participants
    :param Hum_con:
    :param Agent_num: The number of Agent participants
    :param fix: Speak order. if fix then (fix = [[0,1,2],[2,1,0]] for 2 round 3 participates)
    :param MHMA_threadlist: if choose existing thread then put the thread in the MHMA_threadlist
    :param tindex: thread index in MHMA_threadlist
    :param MHMA_Agentlist: if choose existing Assistant than put them in MHMA_Assislist
    :param j_t: 'w' or 'a' to json
    :param Hum_put: Human input after running or use fixed input
    """

    message_data = []

    Total_num = Human_num + Agent_num
    if MHMA_threadlist == []:
        MHMA_threadlist = create_threads(client, 1)
        MHMA_thread = MHMA_threadlist[tindex]

    if MHMA_Agentlist == []:
        MHMA_Agentlist = create_assistants(client,collect_assistant_info(Agent_num))
        MHMA_Object = MHMA_Agentlist


    for n in range(Round):
        print("BEGIN Round {} ----------------------------------------------------------".format(n))
        Order = []
        for i in range(Human_num):
            Order.append(["H",i, Hum_con[n][i]])
        for j in range(Agent_num):
            Order.append(["A",j, MHMA_Object[j]])

        if fix[n] == []:
            Participate = random.sample(range(0, Total_num), Total_num)
        else:
            Participate = fix[n]

        New_order = []
        for k in range(Total_num):
            New_order.append(Order[Participate[k]])

        #print(New_order)

        for m in range(Total_num):
            if New_order[m][0] == "H":
                # Update New_order[m][1] if there is real-time input
                if Hum_put == True:
                    New_order[m][2] = input("User input in round {} position {}:".format(n,m))

                Usermessage = client.beta.threads.messages.create(
                    thread_id=MHMA_thread.id,
                    role="user", content=New_order[m][2]
                )

                messages = client.beta.threads.messages.list(
                    thread_id=MHMA_thread.id
                )

                role = "User"
                content = messages.data[0].content[0].text.value
                message_dict = {'round': n, 'Position': m, 'role': role, 'content': content}
                message_data.append(message_dict)
                print("In system {}| {}:{}".format(message_dict['Position'], message_dict["role"],
                                                     message_dict["content"]))

            if New_order[m][0]=="A":
                run = client.beta.threads.runs.create(
                thread_id=MHMA_thread.id,
                assistant_id=New_order[m][2].id
                )

                run = client.beta.threads.runs.retrieve(
                    thread_id=MHMA_thread.id,
                    run_id=run.id
                )

                time.sleep(2)

                messages = client.beta.threads.messages.list(
                    thread_id=MHMA_thread.id
                )

                role = "Agent"
                name = New_order[m][2].name
                content = messages.data[0].content[0].text.value
                message_dict = {'round': n, 'Position': m, 'role': role, 'name': name, 'content': content}
                message_data.append(message_dict)
                print("In system {}| {} {}:{}".format(message_dict['Position'], message_dict["role"],
                                                     message_dict["name"], message_dict["content"]))
        print("END Round {} ----------------------------------------------------------".format(n))

    with open('messages_MHMA.json', j_t) as file:
        json.dump(message_data, file)

        #display assistant response





#def Test():

    #OHOA_QA(Q_num=2, Question=["What's your name?","What's your hobby"])
    #MHOA_COM(Round= 2,Human_num= 2, Hum_con=[["I chose A","I chose B"],["I chose A","I chose B"]],fix = [[0,1,2],[]])
    #MA_COMP(Round = 2, Agent_num = 2, Initial_instruct=["apple","banana"], fix=[[],[1,0]])
    #MA_COM(Round=1, Agent_num=2, Initial_instruct= ["apple"], fix=[[1,0]])
    #MHMA_COM(Round=2, Human_num=2, Hum_con=[[" "," "],[" "," "]], Agent_num= 2, fix=[[],[]], MHMA_threadlist=[], tindex=0, MHMA_Agentlist=[], j_t='w')


#Test()

