#!/usr/bin/env python3
import sys, pandas as pd, numpy as np
if len(sys.argv)<3: print("Usage: aurc.py rc.csv METRIC(EM|F1)"); exit(1)
df=pd.read_csv(sys.argv[1]); metric=sys.argv[2]
cov=df["coverage"].values; y=df[metric].values
idx=np.argsort(cov); cov=cov[idx]; risk=1.0 - y[idx]
area=np.trapz(risk, cov) + max(0.0, 1.0-cov[-1])*risk[-1]
print(f"AURC({metric}) = {area:.4f}")
