
import sys, pandas as pd, numpy as np
def near(path, cov=0.80):
    df=pd.read_csv(path); i=(df["coverage"]-cov).abs().idxmin(); return df.loc[i]
rows=[]
rows.append({"dataset":"SQuAD","method":"Global-τ (baseline)", **near("results/rc_squad_baseline.csv").to_dict()})
rows.append({"dataset":"SQuAD","method":"PragAURA (per-act τ)", **near("results/rc_squad_pragaura.csv").to_dict()})
rows.append({"dataset":"Hotpot","method":"Global-τ (baseline)", **near("results/rc_hotpot_baseline_v2.csv").to_dict()})
rows.append({"dataset":"Hotpot","method":"PragAURA (per-act τ)", **near("results/rc_hotpot_pragaura_v2.csv").to_dict()})
cols=["dataset","method","coverage","EM","F1","docs_scored","rerank_depth","context_tokens","latency_ms"]
df=pd.DataFrame(rows)[cols]
print(df.to_string(index=False))
df.to_csv("results/compute_parity_all.csv", index=False)
print("\nWrote results/compute_parity_all.csv")
