
import sys, pandas as pd, matplotlib.pyplot as plt

def main(b_csv, p_csv, out_pdf, metric, label_p="PragAURA (per-act)"):
    db = pd.read_csv(b_csv)
    dp = pd.read_csv(p_csv)
    plt.figure()
    plt.plot(db["coverage"], db[metric], marker="o", label="Baseline")
    plt.plot(dp["coverage"], dp[metric], marker="o", label=label_p)
    plt.xlabel("Coverage (1 - abstain)")
    plt.ylabel(metric)
    plt.legend()
    plt.tight_layout()
    plt.savefig(out_pdf)
    print("Wrote", out_pdf)

if __name__ == "__main__":
    if len(sys.argv) < 5:
        print("Usage: plot_rc_simple.py base.csv prg.csv out.pdf METRIC(EM|F1|SCR)")
        sys.exit(1)
    main(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4])
