import sys, pandas as pd, matplotlib.pyplot as plt
if __name__=="__main__":
    if len(sys.argv)<7:
        print("Usage: plot_rc_with_points.py base.csv prg.csv out.pdf metric points.csv label_col"); sys.exit(1)
    b,p,out,metric,pts,label = sys.argv[1:7]
    db=pd.read_csv(b); dp=pd.read_csv(p); pt=pd.read_csv(pts)
    plt.figure()
    plt.plot(db["coverage"], db[metric], marker="o", label="Baseline")
    plt.plot(dp["coverage"], dp[metric], marker="o", label="PragAURA (per-act)")
    plt.scatter(pt["coverage"], pt[metric], s=60, label=None, zorder=3)
    for _,r in pt.iterrows():
        plt.annotate(r[label], (r["coverage"], r[metric]), xytext=(5,5), textcoords="offset points")
    plt.xlabel("Coverage (1 - abstain)"); plt.ylabel(metric); plt.legend(); plt.tight_layout(); plt.savefig(out)
    print("Wrote", out)
